/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.BoardProvider;
import com.volmit.adapt.util.DontObfuscate;
import com.volmit.adapt.util.ScoreDirection;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

@DontObfuscate
public class BoardSettings {
    @DontObfuscate
    private BoardProvider boardProvider;
    @DontObfuscate
    private ScoreDirection scoreDirection;

    BoardSettings(BoardProvider boardProvider, ScoreDirection scoreDirection) {
        this.boardProvider = boardProvider;
        this.scoreDirection = scoreDirection;
    }

    public static BoardSettingsBuilder builder() {
        return new BoardSettingsBuilder();
    }

    public BoardProvider getBoardProvider() {
        return this.boardProvider;
    }

    public ScoreDirection getScoreDirection() {
        return this.scoreDirection;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class BoardSettingsBuilder {
        private BoardProvider boardProvider;
        private ScoreDirection scoreDirection;

        BoardSettingsBuilder() {
        }

        public BoardSettingsBuilder boardProvider(BoardProvider boardProvider) {
            this.boardProvider = boardProvider;
            return this;
        }

        public BoardSettingsBuilder scoreDirection(ScoreDirection scoreDirection) {
            this.scoreDirection = scoreDirection;
            return this;
        }

        public BoardSettings build() {
            return new BoardSettings(this.boardProvider, this.scoreDirection);
        }

        public String toString() {
            return "BoardSettings.BoardSettingsBuilder(boardProvider=" + this.boardProvider + ", scoreDirection=" + this.scoreDirection + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

