/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class BukkitGson {
    public static final Gson gson;

    private static double truncate(double d, int n) {
        if ((double)((int)d) == d) {
            return d;
        }
        return Double.parseDouble(Form.f(d, n));
    }

    private static double truncate(float f, int n) {
        if ((float)((int)f) == f) {
            return f;
        }
        return Float.parseFloat(Form.f(f, n));
    }

    static {
        IBootstrap.dasBoot();
        gson = new GsonBuilder().registerTypeAdapter(World.class, (world, type, jsonSerializationContext) -> jsonSerializationContext.serialize((Object)world.getName())).registerTypeAdapter(World.class, (jsonElement, type, jsonDeserializationContext) -> Bukkit.getWorld((String)jsonElement.getAsString())).registerTypeAdapter(BlockData.class, (blockData, type, jsonSerializationContext) -> new JsonPrimitive(blockData.getAsString(true))).registerTypeAdapter(BlockData.class, (jsonElement, type, jsonDeserializationContext) -> Bukkit.createBlockData((String)jsonElement.getAsString())).registerTypeAdapter(Location.class, (location, type, jsonSerializationContext) -> {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(location.getWorld().getName());
            jsonArray.add((Number)BukkitGson.truncate(location.getX(), 1));
            jsonArray.add((Number)BukkitGson.truncate(location.getY(), 1));
            jsonArray.add((Number)BukkitGson.truncate(location.getZ(), 1));
            jsonArray.add((Number)((int)location.getYaw()));
            jsonArray.add((Number)((int)location.getPitch()));
            return jsonArray;
        }).registerTypeAdapter(Location.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            return new Location(Bukkit.getWorld((String)jsonArray.get(0).getAsString()), jsonArray.get(1).getAsDouble(), jsonArray.get(2).getAsDouble(), jsonArray.get(3).getAsDouble(), jsonArray.get(4).getAsFloat(), jsonArray.get(5).getAsFloat());
        }).registerTypeAdapter(Block.class, (block, type, jsonSerializationContext) -> {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(block.getWorld().getName());
            jsonArray.add((Number)block.getX());
            jsonArray.add((Number)block.getY());
            jsonArray.add((Number)block.getZ());
            return jsonArray;
        }).registerTypeAdapter(Block.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            return new Location(Bukkit.getWorld((String)jsonArray.get(0).getAsString()), (double)jsonArray.get(1).getAsInt(), (double)jsonArray.get(2).getAsInt(), (double)jsonArray.get(3).getAsInt()).getBlock();
        }).registerTypeAdapter(BlockVector.class, (blockVector, type, jsonSerializationContext) -> {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((Number)blockVector.getBlockX());
            jsonArray.add((Number)blockVector.getBlockY());
            jsonArray.add((Number)blockVector.getBlockZ());
            return jsonArray;
        }).registerTypeAdapter(BlockVector.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            return new BlockVector(jsonArray.get(0).getAsInt(), jsonArray.get(1).getAsInt(), jsonArray.get(2).getAsInt());
        }).registerTypeAdapter(Vector.class, (vector, type, jsonSerializationContext) -> {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((Number)BukkitGson.truncate(vector.getX(), 1));
            jsonArray.add((Number)BukkitGson.truncate(vector.getY(), 1));
            jsonArray.add((Number)BukkitGson.truncate(vector.getZ(), 1));
            return jsonArray;
        }).registerTypeAdapter(Vector.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            return new BlockVector(jsonArray.get(0).getAsDouble(), jsonArray.get(1).getAsDouble(), jsonArray.get(2).getAsDouble());
        }).create();
    }
}

