/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.J;
import com.volmit.adapt.util.NastyRunnable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class GroupedExecutor {
    private final ExecutorService service;
    private final Map<String, Integer> mirror = new HashMap<String, Integer>();
    private int xc = 1;

    public GroupedExecutor(int n, final int n2, final String string) {
        if (n == 1) {
            this.service = Executors.newSingleThreadExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName(string);
                thread.setPriority(n2);
                return thread;
            });
        } else if (n > 1) {
            ForkJoinPool.ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
                    ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(forkJoinPool);
                    forkJoinWorkerThread.setName(string + " " + GroupedExecutor.this.xc++);
                    forkJoinWorkerThread.setPriority(n2);
                    return forkJoinWorkerThread;
                }
            };
            this.service = new ForkJoinPool(n, forkJoinWorkerThreadFactory, null, false);
        } else {
            this.service = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName(string + " " + this.xc++);
                thread.setPriority(n2);
                return thread;
            });
        }
    }

    public void waitFor(String string) {
        if (string == null) {
            return;
        }
        if (!this.mirror.containsKey(string)) {
            return;
        }
        while (this.mirror.get(string) != 0) {
        }
    }

    public void queue(String string2, NastyRunnable nastyRunnable) {
        this.mirror.compute(string2, (string, n) -> string == null || n == null ? 1 : n + 1);
        this.service.execute(() -> {
            try {
                nastyRunnable.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.mirror.compute(string2, (string, n) -> n - 1);
        });
    }

    public void close() {
        J.a(() -> {
            J.sleep(100L);
            this.service.shutdown();
        });
    }

    public void closeNow() {
        this.service.shutdown();
    }

    static {
        IBootstrap.dasBoot();
    }
}

