/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.nio.charset.StandardCharsets;
import org.bukkit.ChatColor;

public class HiddenStringUtils {
    private static final String SEQUENCE_HEADER;
    private static final String SEQUENCE_FOOTER;

    public static String encodeString(String string) {
        return HiddenStringUtils.quote(HiddenStringUtils.stringToColors(string));
    }

    public static boolean hasHiddenString(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(SEQUENCE_HEADER) > -1 && string.indexOf(SEQUENCE_FOOTER) > -1;
    }

    public static String extractHiddenString(String string) {
        return HiddenStringUtils.colorsToString(HiddenStringUtils.extract(string));
    }

    public static String replaceHiddenString(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(SEQUENCE_HEADER);
        int n2 = string.indexOf(SEQUENCE_FOOTER);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return string.substring(0, n + SEQUENCE_HEADER.length()) + HiddenStringUtils.stringToColors(string2) + string.substring(n2);
    }

    private static String quote(String string) {
        if (string == null) {
            return null;
        }
        return SEQUENCE_HEADER + string + SEQUENCE_FOOTER;
    }

    private static String extract(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(SEQUENCE_HEADER);
        int n2 = string.indexOf(SEQUENCE_FOOTER);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return string.substring(n + SEQUENCE_HEADER.length(), n2);
    }

    private static String stringToColors(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        char[] cArray = new char[byArray.length * 4];
        for (int i = 0; i < byArray.length; ++i) {
            char[] cArray2 = HiddenStringUtils.byteToHex(byArray[i]);
            cArray[i * 4] = 167;
            cArray[i * 4 + 1] = cArray2[0];
            cArray[i * 4 + 2] = 167;
            cArray[i * 4 + 3] = cArray2[1];
        }
        return new String(cArray);
    }

    private static String colorsToString(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.toLowerCase().replace("\u00a7", "")).length() % 2 != 0) {
            string = string.substring(0, string.length() / 2 * 2);
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        for (int i = 0; i < cArray.length; i += 2) {
            byArray[i / 2] = HiddenStringUtils.hexToByte(cArray[i], cArray[i + 1]);
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static int hexToUnsignedInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        throw new IllegalArgumentException("Invalid hex char: out of range");
    }

    private static char unsignedIntToHex(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(n + 48);
        }
        if (n >= 10 && n <= 15) {
            return (char)(n + 87);
        }
        throw new IllegalArgumentException("Invalid hex int: out of range");
    }

    private static byte hexToByte(char c, char c2) {
        return (byte)((HiddenStringUtils.hexToUnsignedInt(c) << 4 | HiddenStringUtils.hexToUnsignedInt(c2)) + -128);
    }

    private static char[] byteToHex(byte by) {
        int n = by - -128;
        return new char[]{HiddenStringUtils.unsignedIntToHex(n >> 4 & 0xF), HiddenStringUtils.unsignedIntToHex(n & 0xF)};
    }

    static {
        IBootstrap.dasBoot();
        SEQUENCE_HEADER = "" + ChatColor.RESET + ChatColor.UNDERLINE + ChatColor.RESET;
        SEQUENCE_FOOTER = "" + ChatColor.RESET + ChatColor.ITALIC + ChatColor.RESET;
    }
}

