/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarScanner {
    private final Set<Class<?>> classes;
    private final File jar;
    private final String superPackage;

    public JarScanner(File file, String string) {
        this.jar = file;
        this.classes = new HashSet();
        this.superPackage = string;
    }

    public void scan() {
        this.classes.clear();
        FileInputStream fileInputStream = new FileInputStream(this.jar);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string;
            if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".class") && !zipEntry.getName().contains("$") && (string = zipEntry.getName().replaceAll("/", ".").replace(".class", "")).startsWith(this.superPackage)) {
                try {
                    Class<?> clazz = Class.forName(string);
                    this.classes.add(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public File getJar() {
        return this.jar;
    }

    static {
        IBootstrap.dasBoot();
    }
}

