/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class MaterialBlock {
    private Material material;
    private Byte data;

    public MaterialBlock(Material material, Byte by) {
        this.material = material;
        this.data = by;
    }

    public MaterialBlock(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialBlock(Location location) {
        this(location.getBlock());
    }

    public MaterialBlock(BlockState blockState) {
        this.material = blockState.getType();
        this.data = blockState.getData().getData();
    }

    public MaterialBlock(Block block) {
        this.material = block.getType();
        this.data = block.getData();
    }

    public MaterialBlock() {
        this.material = Material.AIR;
        this.data = 0;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Byte getData() {
        return this.data;
    }

    public void setData(Byte by) {
        this.data = by;
    }

    public String toString() {
        if (this.getData() == 0) {
            return this.getMaterial().toString();
        }
        return this.getMaterial().toString() + ":" + this.getData();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.data == null ? 0 : this.data.hashCode());
        n2 = 31 * n2 + (this.material == null ? 0 : this.material.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MaterialBlock materialBlock = (MaterialBlock)object;
        if (this.data == null ? materialBlock.data != null : !this.data.equals(materialBlock.data)) {
            return false;
        }
        return this.material == materialBlock.material;
    }

    static {
        IBootstrap.dasBoot();
    }
}

