/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Average;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;

public class RollingSequence
extends Average {
    private double median = 0.0;
    private double max = 0.0;
    private double min = 0.0;
    private boolean dirtyMedian;
    private int dirtyExtremes;
    private boolean precision;

    public RollingSequence(int n) {
        super(n);
        this.setPrecision(false);
    }

    public double addLast(int n) {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.values.length, n); ++i) {
            d += this.values[i];
        }
        return d;
    }

    public boolean isPrecision() {
        return this.precision;
    }

    public void setPrecision(boolean bl) {
        this.precision = bl;
    }

    public double getMin() {
        if (this.dirtyExtremes > (this.isPrecision() ? 0 : this.values.length)) {
            this.resetExtremes();
        }
        return this.min;
    }

    public double getMax() {
        if (this.dirtyExtremes > (this.isPrecision() ? 0 : this.values.length)) {
            this.resetExtremes();
        }
        return this.max;
    }

    public double getMedian() {
        if (this.dirtyMedian) {
            this.recalculateMedian();
        }
        return this.median;
    }

    private void recalculateMedian() {
        this.median = (Double)XList.middleValue(XList.sort(XList.forceAdd(new ArrayList(), this.values)));
        this.dirtyMedian = false;
    }

    public void resetExtremes() {
        this.max = -2.147483648E9;
        this.min = 2.147483647E9;
        for (double d : this.values) {
            this.max = (Double)M.max((Number[])new Double[]{this.max, d});
            this.min = (Double)M.min((Number[])new Double[]{this.min, d});
        }
        this.dirtyExtremes = 0;
    }

    @Override
    public void put(double d) {
        super.put(d);
        this.dirtyMedian = true;
        ++this.dirtyExtremes;
        this.max = (Double)M.max((Number[])new Double[]{this.max, d});
        this.min = (Double)M.min((Number[])new Double[]{this.min, d});
    }

    static {
        IBootstrap.dasBoot();
    }
}

