/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Arrays;
import org.bukkit.entity.Player;

public abstract class AdvancementVisibility {
    public static final AdvancementVisibility ALWAYS;
    public static final AdvancementVisibility PARENT_GRANTED;
    public static final AdvancementVisibility VANILLA;
    public static final AdvancementVisibility HIDDEN;
    private final String name;

    public AdvancementVisibility() {
        this.name = "CUSTOM";
    }

    private AdvancementVisibility(String string) {
        this.name = string;
    }

    public static AdvancementVisibility parseVisibility(String string) {
        for (AdvancementVisibility advancementVisibility : Arrays.asList(ALWAYS, PARENT_GRANTED, VANILLA, HIDDEN)) {
            if (!advancementVisibility.getName().equalsIgnoreCase(string)) continue;
            return advancementVisibility;
        }
        return VANILLA;
    }

    public abstract boolean isVisible(Player var1, Advancement var2);

    public boolean isAlwaysVisibleWhenAnyChildIsGranted() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    static {
        IBootstrap.dasBoot();
        ALWAYS = new AdvancementVisibility("ALWAYS"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                return true;
            }
        };
        PARENT_GRANTED = new AdvancementVisibility("PARENT_GRANTED"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                if (advancement.isGranted(player)) {
                    return true;
                }
                Advancement advancement2 = advancement.getParent();
                return advancement2 == null || advancement2.isGranted(player);
            }
        };
        VANILLA = new AdvancementVisibility("VANILLA"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                if (advancement.isGranted(player)) {
                    return true;
                }
                Advancement advancement2 = advancement.getParent();
                if (advancement2 != null && !advancement2.isGranted(player)) {
                    Advancement advancement3 = advancement2.getParent();
                    return advancement3 == null || advancement3.getParent() == null || advancement3.isGranted(player);
                }
                return true;
            }
        };
        HIDDEN = new AdvancementVisibility("HIDDEN"){

            @Override
            public boolean isVisible(Player player, Advancement advancement) {
                return advancement.isGranted(player);
            }
        };
    }
}

