/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.Range;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public abstract class AbstractRange<E extends Comparable<E>, ME extends AbstractRange<E, ME>>
implements Range<E, ME> {
    private final E _left;
    private final E _right;
    private final boolean _leftClosed;
    private final boolean _rightClosed;
    private final boolean _reversed;

    public AbstractRange(E e, E e2) {
        this(e, e2, true, true, false);
    }

    public AbstractRange(E e, E e2, boolean bl, boolean bl2, boolean bl3) {
        this.checkArgs(e, e2);
        this._reversed = bl3;
        if (bl3) {
            this._left = e2;
            this._right = e;
            this._leftClosed = bl2;
            this._rightClosed = bl;
        } else {
            this._left = e;
            this._right = e2;
            this._leftClosed = bl;
            this._rightClosed = bl2;
        }
        if (this._left.compareTo(this._right) > 0) {
            throw new IllegalArgumentException("The logical left endpoint is greater than the logical right endpoint: [" + e + ", " + e2 + "]");
        }
    }

    private void checkArgs(E e, E e2) {
        if (e == null) {
            throw new IllegalArgumentException("Non-null value expected for left endpoint.");
        }
        if (e2 == null) {
            throw new IllegalArgumentException("Non-null value expected for right endpoint.");
        }
    }

    @Override
    public E getLeftEndpoint() {
        return this._left;
    }

    @Override
    public E getRightEndpoint() {
        return this._right;
    }

    @Override
    public boolean isLeftClosed() {
        return this._leftClosed;
    }

    @Override
    public boolean isRightClosed() {
        return this._rightClosed;
    }

    @Override
    public boolean contains(E e) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(e) <= 0 : this.getLeftEndpoint().compareTo(e) < 0) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(e) >= 0 : this.getRightEndpoint().compareTo(e) > 0);
    }

    @Override
    public boolean contains(ME ME) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractRange)ME).getLeftEndpoint()) <= 0 : (((AbstractRange)ME).isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractRange)ME).getLeftEndpoint()) < 0 : this.getLeftEndpoint().compareTo(((AbstractRange)ME).getLeftEndpoint()) <= 0)) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractRange)ME).getRightEndpoint()) >= 0 : (((AbstractRange)ME).isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractRange)ME).getRightEndpoint()) > 0 : this.getRightEndpoint().compareTo(((AbstractRange)ME).getRightEndpoint()) >= 0));
    }

    @Override
    public boolean isReversed() {
        return this._reversed;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractRange)) {
            return false;
        }
        AbstractRange abstractRange = (AbstractRange)object;
        if (this.isLeftClosed() != abstractRange.isLeftClosed()) {
            return false;
        }
        if (this.isReversed() != abstractRange.isReversed()) {
            return false;
        }
        if (this.isRightClosed() != abstractRange.isRightClosed()) {
            return false;
        }
        if (!this.getLeftEndpoint().equals(abstractRange.getLeftEndpoint())) {
            return false;
        }
        return this.getRightEndpoint().equals(abstractRange.getRightEndpoint());
    }

    public int hashCode() {
        int n = this.getLeftEndpoint().hashCode();
        n = 31 * n + this.getRightEndpoint().hashCode();
        n = 31 * n + (this.isLeftClosed() ? 1 : 0);
        n = 31 * n + (this.isRightClosed() ? 1 : 0);
        n = 31 * n + (this.isReversed() ? 1 : 0);
        return n;
    }

    public String toString() {
        if (this.isReversed()) {
            return this.getRightEndpoint() + (this.isRightClosed() ? "" : "|") + ".." + (this.isLeftClosed() ? "" : "|") + this.getLeftEndpoint();
        }
        return this.getLeftEndpoint() + (this.isLeftClosed() ? "" : "|") + ".." + (this.isRightClosed() ? "" : "|") + this.getRightEndpoint();
    }

    static {
        IBootstrap.dasBoot();
    }
}

