/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;

public final class ArrayTypeName
extends TypeName {
    public final TypeName componentType;

    private ArrayTypeName(TypeName typeName) {
        this(typeName, new ArrayList<AnnotationSpec>());
    }

    private ArrayTypeName(TypeName typeName, List<AnnotationSpec> list) {
        super(list);
        this.componentType = Util.checkNotNull(typeName, "rawType == null", new Object[0]);
    }

    @Override
    public ArrayTypeName annotated(List<AnnotationSpec> list) {
        return new ArrayTypeName(this.componentType, this.concatAnnotations(list));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new ArrayTypeName(this.componentType);
    }

    @Override
    CodeWriter emit(CodeWriter codeWriter) {
        return this.emit(codeWriter, false);
    }

    CodeWriter emit(CodeWriter codeWriter, boolean bl) {
        this.emitLeafType(codeWriter);
        return this.emitBrackets(codeWriter, bl);
    }

    private CodeWriter emitLeafType(CodeWriter codeWriter) {
        if (TypeName.asArray(this.componentType) != null) {
            return TypeName.asArray(this.componentType).emitLeafType(codeWriter);
        }
        return this.componentType.emit(codeWriter);
    }

    private CodeWriter emitBrackets(CodeWriter codeWriter, boolean bl) {
        if (this.isAnnotated()) {
            codeWriter.emit(" ");
            this.emitAnnotations(codeWriter);
        }
        if (TypeName.asArray(this.componentType) == null) {
            return codeWriter.emit(bl ? "..." : "[]");
        }
        codeWriter.emit("[]");
        return TypeName.asArray(this.componentType).emitBrackets(codeWriter, bl);
    }

    public static ArrayTypeName of(TypeName typeName) {
        return new ArrayTypeName(typeName);
    }

    public static ArrayTypeName of(Type type) {
        return ArrayTypeName.of(TypeName.get(type));
    }

    public static ArrayTypeName get(ArrayType arrayType) {
        return ArrayTypeName.get(arrayType, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static ArrayTypeName get(ArrayType arrayType, Map<TypeParameterElement, TypeVariableName> map) {
        return new ArrayTypeName(ArrayTypeName.get(arrayType.getComponentType(), map));
    }

    public static ArrayTypeName get(GenericArrayType genericArrayType) {
        return ArrayTypeName.get(genericArrayType, new LinkedHashMap<Type, TypeVariableName>());
    }

    static ArrayTypeName get(GenericArrayType genericArrayType, Map<Type, TypeVariableName> map) {
        return ArrayTypeName.of(ArrayTypeName.get(genericArrayType.getGenericComponentType(), map));
    }
}

