/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public final class TypeVariableName
extends TypeName {
    public final String name;
    public final List<TypeName> bounds;

    private TypeVariableName(String string, List<TypeName> list) {
        this(string, list, new ArrayList<AnnotationSpec>());
    }

    private TypeVariableName(String string, List<TypeName> list, List<AnnotationSpec> list2) {
        super(list2);
        this.name = Util.checkNotNull(string, "name == null", new Object[0]);
        this.bounds = list;
        for (TypeName typeName : this.bounds) {
            Util.checkArgument(!typeName.isPrimitive() && typeName != VOID, "invalid bound: %s", typeName);
        }
    }

    @Override
    public TypeVariableName annotated(List<AnnotationSpec> list) {
        return new TypeVariableName(this.name, this.bounds, list);
    }

    @Override
    public TypeName withoutAnnotations() {
        return new TypeVariableName(this.name, this.bounds);
    }

    public TypeVariableName withBounds(Type ... typeArray) {
        return this.withBounds(TypeName.list(typeArray));
    }

    public TypeVariableName withBounds(TypeName ... typeNameArray) {
        return this.withBounds(Arrays.asList(typeNameArray));
    }

    public TypeVariableName withBounds(List<? extends TypeName> list) {
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        arrayList.addAll(this.bounds);
        arrayList.addAll(list);
        return new TypeVariableName(this.name, arrayList, this.annotations);
    }

    private static TypeVariableName of(String string, List<TypeName> list) {
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>(list);
        arrayList.remove(OBJECT);
        return new TypeVariableName(string, Collections.unmodifiableList(arrayList));
    }

    @Override
    CodeWriter emit(CodeWriter codeWriter) {
        this.emitAnnotations(codeWriter);
        return codeWriter.emitAndIndent(this.name);
    }

    public static TypeVariableName get(String string) {
        return TypeVariableName.of(string, Collections.emptyList());
    }

    public static TypeVariableName get(String string, TypeName ... typeNameArray) {
        return TypeVariableName.of(string, Arrays.asList(typeNameArray));
    }

    public static TypeVariableName get(String string, Type ... typeArray) {
        return TypeVariableName.of(string, TypeName.list(typeArray));
    }

    public static TypeVariableName get(javax.lang.model.type.TypeVariable typeVariable) {
        return TypeVariableName.get((TypeParameterElement)typeVariable.asElement());
    }

    static TypeVariableName get(javax.lang.model.type.TypeVariable typeVariable, Map<TypeParameterElement, TypeVariableName> map) {
        TypeParameterElement typeParameterElement = (TypeParameterElement)typeVariable.asElement();
        TypeVariableName typeVariableName = map.get(typeParameterElement);
        if (typeVariableName == null) {
            ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
            List<TypeName> list = Collections.unmodifiableList(arrayList);
            typeVariableName = new TypeVariableName(typeParameterElement.getSimpleName().toString(), list);
            map.put(typeParameterElement, typeVariableName);
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                arrayList.add(TypeName.get(typeMirror, map));
            }
            arrayList.remove(OBJECT);
        }
        return typeVariableName;
    }

    public static TypeVariableName get(TypeParameterElement typeParameterElement) {
        String string = typeParameterElement.getSimpleName().toString();
        List<? extends TypeMirror> list = typeParameterElement.getBounds();
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : list) {
            arrayList.add(TypeName.get(typeMirror));
        }
        return TypeVariableName.of(string, arrayList);
    }

    public static TypeVariableName get(TypeVariable<?> typeVariable) {
        return TypeVariableName.get(typeVariable, new LinkedHashMap<Type, TypeVariableName>());
    }

    static TypeVariableName get(TypeVariable<?> typeVariable, Map<Type, TypeVariableName> map) {
        TypeVariableName typeVariableName = map.get(typeVariable);
        if (typeVariableName == null) {
            ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
            List<TypeName> list = Collections.unmodifiableList(arrayList);
            typeVariableName = new TypeVariableName(typeVariable.getName(), list);
            map.put(typeVariable, typeVariableName);
            for (Type type : typeVariable.getBounds()) {
                arrayList.add(TypeName.get(type, map));
            }
            arrayList.remove(OBJECT);
        }
        return typeVariableName;
    }
}

