/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.multiburst;

import com.volmit.adapt.util.arcane.multiburst.BurstExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MultiBurst {
    public static final MultiBurst burst = new MultiBurst();
    private final AtomicLong last;
    private final String name;
    private final int priority;
    private ExecutorService service;

    public MultiBurst() {
        this("Iris", 1);
    }

    public MultiBurst(String string, int n) {
        this.name = string;
        this.priority = n;
        this.last = new AtomicLong(System.currentTimeMillis());
    }

    private synchronized ExecutorService getService() {
        this.last.set(System.currentTimeMillis());
        if (this.service == null || this.service.isShutdown()) {
            this.service = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
                int m = 0;

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
                    ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(forkJoinPool);
                    forkJoinWorkerThread.setPriority(MultiBurst.this.priority);
                    forkJoinWorkerThread.setName(MultiBurst.this.name + " " + ++this.m);
                    return forkJoinWorkerThread;
                }
            }, (thread, throwable) -> throwable.printStackTrace(), true);
        }
        return this.service;
    }

    public void burst(Runnable ... runnableArray) {
        this.burst(runnableArray.length).queue(runnableArray).complete();
    }

    public void burst(boolean bl, Runnable ... runnableArray) {
        if (bl) {
            this.burst(runnableArray);
        } else {
            this.sync(runnableArray);
        }
    }

    public void burst(List<Runnable> list) {
        this.burst(list.size()).queue(list).complete();
    }

    public void burst(boolean bl, List<Runnable> list) {
        if (bl) {
            this.burst(list);
        } else {
            this.sync(list);
        }
    }

    private void sync(List<Runnable> list) {
        for (Runnable runnable : new ArrayList<Runnable>(list)) {
            runnable.run();
        }
    }

    public void sync(Runnable ... runnableArray) {
        for (Runnable runnable : runnableArray) {
            runnable.run();
        }
    }

    public BurstExecutor burst(int n) {
        return new BurstExecutor(this.getService(), n);
    }

    public BurstExecutor burst() {
        return this.burst(16);
    }

    public BurstExecutor burst(boolean bl) {
        BurstExecutor burstExecutor = this.burst();
        burstExecutor.setMulticore(bl);
        return burstExecutor;
    }

    public <T> Future<T> lazySubmit(Callable<T> callable) {
        return this.getService().submit(callable);
    }

    public void lazy(Runnable runnable) {
        this.getService().execute(runnable);
    }

    public Future<?> future(Runnable runnable) {
        return this.getService().submit(runnable);
    }

    public Future<?> complete(Runnable runnable) {
        return this.getService().submit(runnable);
    }

    public <T> Future<T> completeValue(Callable<T> callable) {
        return this.getService().submit(callable);
    }

    public void close() {
        if (this.service != null) {
            this.service.shutdown();
            long l = System.currentTimeMillis();
            try {
                while (!this.service.awaitTermination(1L, TimeUnit.SECONDS)) {
                    if (System.currentTimeMillis() - l <= 7000L) continue;
                    try {
                        this.service.shutdownNow();
                    }
                    catch (Throwable throwable) {}
                    break;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

