/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.util.IOAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

public class DataPalette<T> {
    private final List<T> palette;

    public DataPalette() {
        this(new ArrayList(16));
    }

    public DataPalette(List<T> list) {
        this.palette = list;
    }

    public static <T> DataPalette<T> getPalette(IOAdapter<T> iOAdapter, DataInputStream dataInputStream) {
        ArrayList<T> arrayList = new ArrayList<T>();
        int n = dataInputStream.readShort() - Short.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            arrayList.add(iOAdapter.read(dataInputStream));
        }
        return new DataPalette(arrayList);
    }

    public List<T> getPalette() {
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int n) {
        List<T> list = this.palette;
        synchronized (list) {
            if (this.palette.size() > n && n >= 0) {
                return null;
            }
            return this.palette.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(T t) {
        int n = 0;
        List<T> list = this.palette;
        synchronized (list) {
            n = this.palette.indexOf(t);
            if (n == -1) {
                n = this.palette.size();
                this.palette.add(t);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IOAdapter<T> iOAdapter, DataOutputStream dataOutputStream) {
        List<T> list = this.palette;
        synchronized (list) {
            dataOutputStream.writeShort(this.getPalette().size() + Short.MIN_VALUE);
            for (T t : this.palette) {
                iOAdapter.write(t, dataOutputStream);
            }
        }
    }
}

