/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final AtomicReferenceArray<T> data;

    public AtomicHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new AtomicReferenceArray(n * n2 * n3);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        this.data.set(this.index(n, n2, n3), t);
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    public AtomicReferenceArray<T> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "AtomicHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AtomicHunk)) {
            return false;
        }
        AtomicHunk atomicHunk = (AtomicHunk)object;
        if (!atomicHunk.canEqual(this)) {
            return false;
        }
        AtomicReferenceArray<T> atomicReferenceArray = this.getData();
        AtomicReferenceArray<T> atomicReferenceArray2 = atomicHunk.getData();
        return !(atomicReferenceArray == null ? atomicReferenceArray2 != null : !atomicReferenceArray.equals(atomicReferenceArray2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof AtomicHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        AtomicReferenceArray<T> atomicReferenceArray = this.getData();
        n2 = n2 * 59 + (atomicReferenceArray == null ? 43 : atomicReferenceArray.hashCode());
        return n2;
    }
}

