/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.spatial.mantle.MantleChunk;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class MantleRegion {
    private final int sectionHeight;
    private final AtomicReferenceArray<MantleChunk> chunks;
    private final int x;
    private final int z;

    public MantleRegion(int n, int n2, int n3) {
        this.sectionHeight = n >> 4;
        this.chunks = new AtomicReferenceArray(1024);
        this.x = n2;
        this.z = n3;
    }

    public MantleRegion(int n, DataInputStream dataInputStream) {
        this(n, dataInputStream.readInt(), dataInputStream.readInt());
        for (int i = 0; i < this.chunks.length(); ++i) {
            if (!dataInputStream.readBoolean()) continue;
            this.chunks.set(i, new MantleChunk(this.sectionHeight, dataInputStream));
        }
    }

    public static MantleRegion read(int n, File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        DataInputStream dataInputStream = new DataInputStream(gZIPInputStream);
        MantleRegion mantleRegion = new MantleRegion(n, dataInputStream);
        dataInputStream.close();
        return mantleRegion;
    }

    public boolean exists(int n, int n2) {
        return this.get(n, n2) != null;
    }

    public MantleChunk get(int n, int n2) {
        return this.chunks.get(this.index(n, n2));
    }

    public void clear() {
        for (int i = 0; i < this.chunks.length(); ++i) {
            this.chunks.set(i, null);
        }
    }

    public void delete(int n, int n2) {
        this.chunks.set(this.index(n, n2), null);
    }

    public MantleChunk getOrCreate(int n, int n2) {
        MantleChunk mantleChunk = this.get(n, n2);
        if (mantleChunk == null) {
            mantleChunk = new MantleChunk(this.sectionHeight, n & 0x1F, n2 & 0x1F);
            this.chunks.set(this.index(n, n2), mantleChunk);
        }
        return mantleChunk;
    }

    private int index(int n, int n2) {
        return CompressedNumbers.index3Dto1D(n, n2, 0, 32, 32);
    }

    public void write(File file) {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(gZIPOutputStream);
        this.write(dataOutputStream);
        dataOutputStream.close();
    }

    public void write(DataOutputStream dataOutputStream) {
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.z);
        for (int i = 0; i < this.chunks.length(); ++i) {
            MantleChunk mantleChunk = this.chunks.get(i);
            if (mantleChunk != null) {
                dataOutputStream.writeBoolean(true);
                mantleChunk.write(dataOutputStream);
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

