/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.lang.String;

import com.volmit.adapt.util.arcane.amulet.io.IO;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Extension
public class XString {
    public static String upper(@This String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public static byte[] md5(@This String string) {
        return IO.hashMD5(string);
    }

    public static String fromBase64(@This String string) {
        return new String(Base64.getUrlDecoder().decode(string), StandardCharsets.UTF_8);
    }

    public static String toBase64String(@This String string) {
        return Base64.getUrlEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] toBase64(@This String string) {
        return Base64.getUrlEncoder().encode(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha1(@This String string) {
        return IO.hashSHA1(string);
    }

    public static byte[] sha512(@This String string) {
        return IO.hashSHA512(string);
    }

    public static byte[] sha384(@This String string) {
        return IO.hashSHA384(string);
    }

    public static byte[] sha256(@This String string) {
        return IO.hashSHA256(string);
    }

    public static byte[] hash(@This String string, String string2) {
        return IO.hash(string, string2);
    }

    public static String lower(@This String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static double toDouble(@This String string) {
        return Double.parseDouble(string);
    }

    public static double toDouble(@This String string, double d) {
        try {
            return XString.toDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static int toInt(@This String string) {
        return Integer.parseInt(string);
    }

    public static int toInt(@This String string, int n) {
        try {
            return XString.toInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long toLong(@This String string) {
        return Long.parseLong(string);
    }

    public static long toLong(@This String string, long l) {
        try {
            return XString.toLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static String replaceAbs(@This String string, String string2, String string3) {
        return string.replaceAll("\\Q" + string2 + "\\E", string3);
    }

    public static String[] splitAbs(@This String string, String string2) {
        return string.split("\\Q" + string2 + "\\E");
    }

    public static String remove(@This String string, String string2) {
        return XString.replaceAbs(string, string2, "");
    }

    public static boolean isNotEmpty(@This String string) {
        return !string.isEmpty();
    }

    public static String normalize(@This String string) {
        String string2 = string;
        while (string2.contains("  ")) {
            string2 = XString.replaceAbs(string2, "  ", " ");
        }
        return string2.trim();
    }

    public static String capitalize(@This String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        char[] cArray = string.trim().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c.charValue()));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String capitalizeWords(@This String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.trim().split(" ")) {
            stringBuilder.append(" ").append(XString.capitalize(string2.trim()));
        }
        return stringBuilder.substring(1);
    }

    public static String wrap(@This String string, int n) {
        return XString.wrap(string, n, null, false);
    }

    public static String wrapWords(@This String string, int n) {
        return XString.wrap(string, n, null, true);
    }

    public static String wrap(@This String string, int n, String string2, boolean bl) {
        return XString.wrap(string, n, string2, bl, " ");
    }

    public static String wrap(@This String string, int n, String string2, boolean bl, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "\n";
        }
        if (n < 1) {
            n = 1;
        }
        if (string3.trim().equals("")) {
            string3 = " ";
        }
        Pattern pattern = Pattern.compile(string3);
        int n2 = string.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        while (n3 < n2) {
            int n4 = -1;
            Matcher matcher = pattern.matcher(string.substring(n3, Math.min(n3 + n + 1, n2)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    n3 += matcher.end();
                    continue;
                }
                n4 = matcher.start();
            }
            if (n2 - n3 <= n) break;
            while (matcher.find()) {
                n4 = matcher.start() + n3;
            }
            if (n4 >= n3) {
                stringBuilder.append(string, n3, n4);
                stringBuilder.append(string2);
                n3 = n4 + 1;
                continue;
            }
            if (bl) {
                stringBuilder.append(string, n3, n + n3);
                stringBuilder.append(string2);
                n3 += n;
                continue;
            }
            matcher = pattern.matcher(string.substring(n3 + n));
            if (matcher.find()) {
                n4 = matcher.start() + n3 + n;
            }
            if (n4 >= 0) {
                stringBuilder.append(string, n3, n4);
                stringBuilder.append(string2);
                n3 = n4 + 1;
                continue;
            }
            stringBuilder.append(string.substring(n3));
            n3 = n2;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String elipse(@This String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n) + "...";
    }

    public static int fromRoman(@This String string) {
        if (string.isEmpty()) {
            return 0;
        }
        if ((string = string.toUpperCase()).startsWith("M")) {
            return 1000 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("CM")) {
            return 900 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("D")) {
            return 500 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("CD")) {
            return 400 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("C")) {
            return 100 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("XC")) {
            return 90 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("L")) {
            return 50 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("XL")) {
            return 40 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("X")) {
            return 10 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("IX")) {
            return 9 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("V")) {
            return 5 + XString.fromRoman(string.substring(1));
        }
        if (string.startsWith("IV")) {
            return 4 + XString.fromRoman(string.substring(2));
        }
        if (string.startsWith("I")) {
            return 1 + XString.fromRoman(string.substring(1));
        }
        return 0;
    }

    public static String scroll(@This String string, int n, long l) {
        int n2;
        int n3;
        String string2 = " ".repeat(n) + string + " ".repeat(n);
        String string3 = string2.substring(n3 = (int)(l % (long)((n2 = string2.length()) - n)), Math.min(n3 + n, n2 - 1));
        string3 = string3.length() < n ? string3 + " ".repeat(n - string3.length() - 3) : string3;
        return string3;
    }

    static {
        IBootstrap.dasBoot();
    }
}

