/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.List;

import com.volmit.adapt.util.arcane.amulet.MagicalSugar;
import com.volmit.adapt.util.arcane.amulet.functional.Consume;
import com.volmit.adapt.util.extensions.java.util.Random.XRandom;
import com.volmit.adapt.util.extensions.java.util.stream.Stream.XStream;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Extension
public class XList {
    @Self
    public static <E> List<E> withoutDuplicates(@This List<E> list) {
        return XList.withoutDuplicates(list, ArrayList::new);
    }

    public static <E> E getRandom(@This List<E> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(XRandom.i(random, 0, XList.last(list)));
    }

    public static <E> E getRandom(@This List<E> list) {
        return XList.getRandom(list, XRandom.r());
    }

    public static <E> boolean addIfMissing(@This List<E> list, E e) {
        if (!list.contains(e)) {
            list.add(e);
            return true;
        }
        return false;
    }

    @Self
    public static <E> List<E> where(@This List<E> list, Predicate<E> predicate) {
        return XStream.where(list.stream(), predicate).toList();
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, Object[] objectArray) {
        for (Object object : objectArray) {
            list.add(object);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            list.add(n2);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, double[] dArray) {
        double[] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray2[i];
            list.add(d);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, float[] fArray) {
        float[] fArray2 = fArray;
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            Float f = Float.valueOf(fArray2[i]);
            list.add(f);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, byte[] byArray) {
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            Byte by = byArray2[i];
            list.add(by);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, short[] sArray) {
        short[] sArray2 = sArray;
        int n = sArray2.length;
        for (int i = 0; i < n; ++i) {
            Short s = sArray2[i];
            list.add(s);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, long[] lArray) {
        long[] lArray2 = lArray;
        int n = lArray2.length;
        for (int i = 0; i < n; ++i) {
            Long l = lArray2[i];
            list.add(l);
        }
        return list;
    }

    @Self
    public static <E> List<E> forceAdd(@This List<E> list, boolean[] blArray) {
        boolean[] blArray2 = blArray;
        int n = blArray2.length;
        for (int i = 0; i < n; ++i) {
            Boolean bl = blArray2[i];
            list.add(bl);
        }
        return list;
    }

    @Self
    public static <E> List<E> sort(@This List<E> list) {
        list.sort(Comparator.comparing(Object::toString));
        return list;
    }

    @Self
    public static <E> List<E> withoutDuplicates(@This List<E> list, Supplier<List<E>> supplier) {
        List<E> list2 = supplier.get();
        list2.addAll(new HashSet<E>(list));
        return list2;
    }

    public static <E> E middleValue(@This List<E> list) {
        return list.get(XList.middleIndex(list));
    }

    public static <E> int middleIndex(@This List<E> list) {
        return list.size() % 2 == 0 ? list.size() / 2 : list.size() / 2 + 1;
    }

    @Self
    public static <E> List<E> forEachIndex(@This List<E> list, Consume.Two<List<E>, Integer> two) {
        Iterator iterator = MagicalSugar.index.prefixBind(list).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            two.accept(list, n);
        }
        return list;
    }

    @Self
    public static <E> List<E> forEachReverseIndex(@This List<E> list, Consume.Two<List<E>, Integer> two) {
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(list)).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            two.accept(list, n);
        }
        return list;
    }

    @Self
    public static <E> List<E> evenValues(@This List<E> list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(list)).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n % 2 != 0) continue;
            XList.addFirst(arrayList, list.remove(n));
        }
        return arrayList;
    }

    @Self
    public static <E> List<E> oddValues(@This List<E> list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(list)).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n % 2 == 0) continue;
            XList.addFirst(arrayList, list.remove(n));
        }
        return arrayList;
    }

    @Self
    public static <E> List<E> copy(@This List<E> list) {
        return XList.copy(list, ArrayList::new);
    }

    @Self
    public static <E> List<E> copyClear(@This List<E> list) {
        List<E> list2 = XList.copy(list);
        list.clear();
        return list2;
    }

    @Self
    public static <E> List<E> unmodifiable(@This List<E> list) {
        return Collections.unmodifiableList(list);
    }

    @Self
    public static <E> List<E> copy(@This List<E> list, Supplier<List<E>> supplier) {
        List<E> list2 = supplier.get();
        list2.addAll(list);
        return list2;
    }

    public static <E> int last(@This List<E> list) {
        return list.size() - 1;
    }

    @Self
    public static <E> List<E> removeLast(@This List<E> list) {
        if (list.isEmpty()) {
            return list;
        }
        list.remove(XList.last(list));
        return list;
    }

    public static <E> boolean isNotEmpty(@This List<E> list) {
        return !list.isEmpty();
    }

    @SafeVarargs
    @Self
    public static <E> List<E> add(@This List<E> list, E ... EArray) {
        Collections.addAll(list, EArray);
        return list;
    }

    @SafeVarargs
    @Self
    public static <E> List<E> qadd(@This List<E> list, E ... EArray) {
        Collections.addAll(list, EArray);
        return list;
    }

    @Self
    public static <E> List<E> add(@This List<E> list, List<E> list2) {
        list.addAll(list2);
        return list;
    }

    @Self
    public static <E> List<E> addFirst(@This List<E> list, E e) {
        list.add(0, e);
        return list;
    }

    @SafeVarargs
    @Self
    public static <E> List<E> remove(@This List<E> list, E ... EArray) {
        for (E e : EArray) {
            list.remove(e);
        }
        return list;
    }

    @Self
    public static <E> List<E> remove(@This List<E> list, List<E> list2) {
        for (E e : list2) {
            list.remove(e);
        }
        return list;
    }

    @Self
    public static <E> List<E> swapIndexes(@This List<E> list, int n, int n2) {
        E e = list.remove(n);
        E e2 = list.get(n2);
        list.add(n, e2);
        list.remove(n2);
        list.add(n2, e);
        return list;
    }

    @Self
    public static <E> List<E> removeWhere(@This List<E> list, Predicate<E> predicate) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        Iterator iterator = MagicalSugar.reverse.prefixBind(MagicalSugar.index.prefixBind(list)).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!predicate.test(list.get(n))) continue;
            arrayList.add(list.get(n));
        }
        list.removeAll(arrayList);
        return list;
    }

    @Self
    public static <E> List<E> keepWhere(@This List<E> list, Predicate<E> predicate) {
        return XList.removeWhere(list, predicate.negate());
    }

    @Self
    public static <E, R> List<R> convert(@This List<E> list, Function<E, R> function) {
        ArrayList<R> arrayList = new ArrayList<R>();
        for (E e : list) {
            R r = function.apply(e);
            if (r == null) continue;
            arrayList.add(r);
        }
        return arrayList;
    }

    public static <E> E pop(@This List<E> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.remove(0);
    }

    public static <E> E popLast(@This List<E> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.remove(XList.last(list));
    }

    @Extension
    public static <E> List<E> from(Collection<E> collection) {
        return XList.from(collection, ArrayList::new);
    }

    @Extension
    public static <E> CopyOnWriteArrayList<E> copyOnWrite() {
        return new CopyOnWriteArrayList();
    }

    @Extension
    public static <E> ArrayList<E> array() {
        return new ArrayList();
    }

    @Extension
    public static <E> LinkedList<E> linked() {
        return new LinkedList();
    }

    @Extension
    public static <E> List<E> from(Collection<E> collection, Supplier<List<E>> supplier) {
        List<E> list = supplier.get();
        list.addAll(collection);
        return list;
    }

    @SafeVarargs
    @Extension
    public static <E> List<E> from(E ... EArray) {
        return XList.from(ArrayList::new, EArray);
    }

    @SafeVarargs
    public static <E> List<E> from(Supplier<List<E>> supplier, E ... EArray) {
        List<E> list = supplier.get();
        XList.add(list, EArray);
        return list;
    }

    public static <E> E popRandom(@This List<E> list) {
        return XList.popRandom(list, XRandom.r());
    }

    public static <E> E popRandom(@This List<E> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        return list.remove(XRandom.i(random, 0, XList.last(list)));
    }

    @Self
    public static <E> List<E> minus(@This List<E> list, E e) {
        List<E> list2 = XList.from(list);
        list2.remove(e);
        return list2;
    }

    @Self
    public static <E> List<E> minus(@This List<E> list, Collection<E> collection) {
        List<E> list2 = XList.from(list);
        list2.removeAll(collection);
        return list2;
    }

    @Self
    public static <E> List<E> reverse(@This List<E> list) {
        Collections.reverse(list);
        return list;
    }

    @Self
    public static <E> List<E> unaryMinus(@This List<E> list) {
        return XList.reverse(XList.from(list));
    }

    @Self
    public static <E> List<E> minus(@This List<E> list, List<E> list2) {
        return XList.remove(XList.from(list), list2);
    }

    public static <E> boolean hasIndex(@This List<E> list, int n) {
        return list.size() > n && n >= 0;
    }

    public static <E> String toString(@This List<E> list, String string) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return "" + list.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (E e : list) {
            stringBuilder.append(string).append(e);
        }
        return stringBuilder.substring(string.length());
    }

    static {
        IBootstrap.dasBoot();
    }
}

