/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.stream.Stream;

import com.volmit.adapt.util.arcane.amulet.functional.Function;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@Extension
public class XStream {
    public static <T, R> R splitInterlace(@This Stream<T> stream, Function.Two<Stream<T>, Stream<T>, R> two) {
        List<T> list = stream.toList();
        return two.apply(XList.evenValues(list).stream(), XList.oddValues(list).stream());
    }

    public static <T> Set<T> toSet(@This Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <T> IntStream ints(@This Stream<T> stream) {
        return stream.mapToInt(object -> (Integer)object);
    }

    public static <T> DoubleStream doubles(@This Stream<T> stream) {
        return stream.mapToDouble(object -> (Double)object);
    }

    public static <T> LongStream longs(@This Stream<T> stream) {
        return stream.mapToLong(object -> (Long)object);
    }

    @Self
    public static <T> Stream<T> and(@This Stream<T> stream, Stream<T> stream2) {
        return Stream.concat(stream, stream2);
    }

    @Self
    public static <T> Stream<T> where(@This Stream<T> stream, Predicate<T> predicate) {
        return stream.filter(predicate);
    }

    @Self
    public static <T> Stream<T> without(@This Stream<T> stream, Predicate<T> predicate) {
        return stream.filter(predicate.negate());
    }

    @Self
    public static <T> Stream<T> and(@This Stream<T> stream, T t) {
        return XStream.and(stream, Stream.of(t));
    }

    @Self
    public static <T> Stream<T> plus(@This Stream<T> stream, Stream<T> stream2) {
        return Stream.concat(stream, stream2);
    }

    static {
        IBootstrap.dasBoot();
    }
}

