/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util;

import com.volmit.adapt.util.manifold.util.JreUtil;
import com.volmit.adapt.util.manifold.util.ManExceptionUtil;
import com.volmit.adapt.util.manifold.util.MethodScore;
import com.volmit.adapt.util.manifold.util.MethodScorer;
import com.volmit.adapt.util.manifold.util.NecessaryEvilUtil;
import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentHashSet;
import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentWeakHashMap;
import com.volmit.adapt.util.manifold.util.concurrent.LocklessLazyVar;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ReflectUtil {
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, ConcurrentHashSet<Method>>> _methodsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, Field>> _fieldsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, Set<Constructor>> _constructorsByClass = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Method, ConcurrentMap<Class, Method>> _structuralCall = new ConcurrentWeakHashMap();
    private static final LocklessLazyVar<ClassContextSecurityManager> _sm = LocklessLazyVar.make(() -> new ClassContextSecurityManager());
    private static final String LAMBDA_METHOD = "lambda method";
    private static final Object UNHANDLED = new Object(){};
    private static final LocklessLazyVar<Long> _overrideOffset = LocklessLazyVar.make(() -> {
        try {
            Field field = FakeAccessibleObject.class.getDeclaredField("override");
            return NecessaryEvilUtil.getUnsafe().objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    });
    private static final LocklessLazyVar<Method> _getDeclaredMethods0 = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method method = Class.class.getDeclaredMethod("getDeclaredMethods0", Boolean.TYPE);
                ReflectUtil.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _copyMethod = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method method = Method.class.getDeclaredMethod("copy", new Class[0]);
                ReflectUtil.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _getDeclaredFields0 = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method method = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                ReflectUtil.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _copyField = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method method = Field.class.getDeclaredMethod("copy", new Class[0]);
                ReflectUtil.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });

    public static Class<?> type(String string) {
        return ReflectUtil.type(string, false);
    }

    public static Class<?> type(String string, boolean bl) {
        return ReflectUtil.type(string, ReflectUtil.class.getClassLoader(), bl);
    }

    public static Class<?> type(String string, ClassLoader classLoader) {
        return ReflectUtil.type(string, classLoader, false);
    }

    public static Class<?> type(String string, ClassLoader classLoader, boolean bl) {
        Class<?> clazz;
        int n = 0;
        int n2 = string.indexOf(91);
        String string2 = string;
        if (n2 > 0) {
            n = (string.length() - n2) / 2;
            string2 = string.substring(0, n2);
        }
        try {
            clazz = ReflectUtil.classForPrimitiveName(string2);
            if (clazz == null) {
                clazz = Class.forName(string2, false, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader != classLoader2 && classLoader2 != null) {
                return ReflectUtil.type(string, classLoader2, bl);
            }
            Class<?> clazz2 = clazz = bl ? ReflectUtil.findInCallChain(string) : null;
        }
        if (clazz != null && n > 0) {
            clazz = Array.newInstance(clazz, new int[n]).getClass();
        }
        return clazz;
    }

    private static Class<?> classForPrimitiveName(String string) {
        switch (string) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    private static Class<?> findInCallChain(String string) {
        Class[] classArray = Objects.requireNonNull(_sm.get()).getClassContext();
        if (classArray == null) {
            return null;
        }
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        hashSet.add(ReflectUtil.class.getClassLoader());
        hashSet.add(Thread.currentThread().getContextClassLoader());
        for (Class clazz : classArray) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (hashSet.contains(classLoader)) continue;
            hashSet.add(classLoader);
            return ReflectUtil.type(string, classLoader, false);
        }
        return null;
    }

    public static LiveMethodRef method(Object object, String string, Class ... classArray) {
        LiveMethodRef liveMethodRef = WithNull.method(object, string, classArray);
        if (liveMethodRef == null) {
            throw new RuntimeException("Method '" + string + "' not found");
        }
        return liveMethodRef;
    }

    public static MethodRef method(String string, String string2, Class ... classArray) {
        return ReflectUtil.method(ReflectUtil.type(string), string2, classArray);
    }

    public static MethodRef method(Class<?> clazz, String string, Class ... classArray) {
        return ReflectUtil._method(clazz, string, classArray);
    }

    private static MethodRef _method(Class<?> clazz, String string, Class ... classArray) {
        MethodRef methodRef = ReflectUtil.matchFirstMethod(clazz, string, classArray);
        if (methodRef != null) {
            return methodRef;
        }
        MethodRef methodRef2 = ReflectUtil.getMethodFromCache(clazz, string, classArray);
        if (methodRef2 != null) {
            return methodRef2;
        }
        try {
            Method method = ReflectUtil.getDeclaredMethod(clazz, string, classArray);
            return ReflectUtil.addMethodToCache(clazz, method);
        }
        catch (Exception exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && (methodRef2 = ReflectUtil._method(clazz2, string, classArray)) != null) {
                ReflectUtil.addMethodToCache(clazz, methodRef2._method);
                return methodRef2;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                methodRef2 = ReflectUtil._method(clazz3, string, classArray);
                if (methodRef2 == null) continue;
                ReflectUtil.addMethodToCache(clazz, methodRef2._method);
                return methodRef2;
            }
            return null;
        }
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        if (!JreUtil.isJava12orLater()) {
            return clazz.getDeclaredMethods();
        }
        try {
            return (Method[])_getDeclaredMethods0.get().invoke(clazz, false);
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        if (!JreUtil.isJava12orLater()) {
            return clazz.getDeclaredMethod(string, classArray);
        }
        try {
            Method[] methodArray = (Method[])_getDeclaredMethods0.get().invoke(clazz, false);
            Method method = null;
            for (Method method2 : methodArray) {
                if (!method2.getName().equals(string) || !ReflectUtil.sameParameters(classArray, method2.getParameterTypes()) || method != null && !method.getReturnType().isAssignableFrom(method2.getReturnType())) continue;
                method = method2;
            }
            if (method == null) {
                throw new NoSuchMethodException();
            }
            return (Method)_copyMethod.get().invoke(method, new Object[0]);
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static boolean sameParameters(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray == null) {
            return classArray2 == null || classArray2.length == 0;
        }
        if (classArray2 == null) {
            return classArray.length == 0;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == classArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static MethodRef methodFromName(Class<?> clazz, String string) {
        MethodRef methodRef = ReflectUtil.getMethodFromCacheUsingNameOnly(clazz, string);
        if (methodRef != null) {
            return methodRef;
        }
        for (Method method : ReflectUtil.getDeclaredMethods(clazz)) {
            if (!method.getName().equals(string)) continue;
            return ReflectUtil.addMethodToCache(clazz, method);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (methodRef = ReflectUtil.methodFromName(clazz2, string)) != null) {
            ReflectUtil.addMethodToCache(clazz, methodRef._method);
            return methodRef;
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            methodRef = ReflectUtil.methodFromName(clazz3, string);
            if (methodRef == null) continue;
            ReflectUtil.addMethodToCache(clazz, methodRef._method);
            return methodRef;
        }
        return null;
    }

    public static MethodRef lambdaMethod(Class<?> clazz) {
        MethodRef methodRef = ReflectUtil.getMethodFromCacheUsingNameOnly(clazz, LAMBDA_METHOD);
        if (methodRef != null) {
            return methodRef;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method method : clazz2.getMethods()) {
                if ((method.getModifiers() & 0x401) != 1025) continue;
                return ReflectUtil.addMethodToCache(clazz, method, LAMBDA_METHOD);
            }
        }
        return null;
    }

    public static Object invokeDefault(Object object, Class<?> clazz, String string, Class<?>[] classArray, Object ... objectArray) {
        return ReflectUtil.invokeDefault(object, ReflectUtil.method(clazz, string, (Class[])classArray).getMethod(), objectArray);
    }

    public static Object invokeDefault(Object object, Method method, Object ... objectArray) {
        try {
            ReflectUtil.fakeProxyStructuralArgs(method, objectArray);
            Class<?> clazz = method.getDeclaringClass();
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)ReflectUtil.constructor(MethodHandles.Lookup.class, Class.class).newInstance(clazz);
            return lookup.in(clazz).unreflectSpecial(method, clazz).bindTo(object).invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            throw ManExceptionUtil.unchecked(throwable);
        }
    }

    private static void fakeProxyStructuralArgs(Method method, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            Class<?>[] classArray = method.getParameterTypes();
            block0: for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[0];
                if (object == null) continue;
                for (Annotation annotation : classArray[i].getAnnotations()) {
                    if (!annotation.annotationType().getTypeName().equals("com.volmit.adapt.util.manifold.ext.rt.api.Structural")) continue;
                    objectArray[0] = Proxy.newProxyInstance(classArray[i].getClassLoader(), new Class[]{classArray[i]}, (InvocationHandler)new FakeProxy(object));
                    continue block0;
                }
            }
        }
    }

    private static MethodRef matchFirstMethod(Class<?> clazz, String string, Class[] classArray) {
        if (string.indexOf(124) >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                MethodRef methodRef = ReflectUtil.method(clazz, string2, classArray);
                if (methodRef == null) continue;
                return methodRef;
            }
        }
        return null;
    }

    public static LiveFieldRef field(Object object, String string) {
        LiveFieldRef liveFieldRef = WithNull.field(object, string);
        if (liveFieldRef == null) {
            throw new RuntimeException("Field '" + string + "' not found");
        }
        return liveFieldRef;
    }

    public static FieldRef field(String string, String string2) {
        return ReflectUtil.field(ReflectUtil.type(string), string2);
    }

    public static FieldRef field(Class<?> clazz, String string) {
        return ReflectUtil._field(clazz, string);
    }

    private static FieldRef _field(Class<?> clazz, String string) {
        FieldRef fieldRef = ReflectUtil.matchFirstField(clazz, string);
        if (fieldRef != null) {
            return fieldRef;
        }
        FieldRef fieldRef2 = ReflectUtil.getFieldFromCache(clazz, string);
        if (fieldRef2 != null) {
            return fieldRef2;
        }
        try {
            Field field = ReflectUtil.getDeclaredField(clazz, string);
            return ReflectUtil.addFieldToCache(clazz, field);
        }
        catch (Exception exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && (fieldRef2 = ReflectUtil._field(clazz2, string)) != null) {
                ReflectUtil.addFieldToCache(clazz, fieldRef2._field);
                return fieldRef2;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                fieldRef2 = ReflectUtil._field(clazz3, string);
                if (fieldRef2 == null) continue;
                ReflectUtil.addFieldToCache(clazz, fieldRef2._field);
                return fieldRef2;
            }
            return null;
        }
    }

    public static List<LiveFieldRef> fields(Object object) {
        return ReflectUtil.fields(object, null);
    }

    public static List<LiveFieldRef> fields(Object object, Predicate<LiveFieldRef> predicate) {
        if (object == null) {
            throw new NullPointerException("Receiver is null");
        }
        Class<?> clazz = object.getClass();
        try {
            List<Field> list = ReflectUtil.fields(clazz);
            return list.stream().map(field -> ReflectUtil.field(object, field.getName())).filter(liveFieldRef -> predicate != null && predicate.test((LiveFieldRef)liveFieldRef)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static List<Field> fields(Class clazz) {
        try {
            Field[] fieldArray = JreUtil.isJava12orLater() ? (Field[])_getDeclaredFields0.get().invoke((Object)clazz, false) : clazz.getDeclaredFields();
            ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(fieldArray));
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                arrayList.addAll(ReflectUtil.fields(clazz2));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static Field getDeclaredField(Class<?> clazz, String string) {
        if (!JreUtil.isJava12orLater()) {
            return clazz.getDeclaredField(string);
        }
        try {
            Field[] fieldArray = (Field[])_getDeclaredFields0.get().invoke(clazz, false);
            Field field = null;
            for (Field field2 : fieldArray) {
                if (!field2.getName().equals(string)) continue;
                field = field2;
                break;
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            return (Field)_copyField.get().invoke(field, new Object[0]);
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static FieldRef matchFirstField(Class<?> clazz, String string) {
        if (string.indexOf(124) >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                FieldRef fieldRef = ReflectUtil.field(clazz, string2);
                if (fieldRef == null) continue;
                return fieldRef;
            }
        }
        return null;
    }

    public static ConstructorRef constructor(String string, Class<?> ... classArray) {
        return ReflectUtil.constructor(ReflectUtil.type(string), classArray);
    }

    public static ConstructorRef constructor(Class<?> clazz, Class<?> ... classArray) {
        ConstructorRef constructorRef = ReflectUtil.getConstructorFromCache(clazz, classArray);
        if (constructorRef != null) {
            return constructorRef;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return ReflectUtil.addConstructorToCache(clazz, constructor);
        }
        catch (Exception exception) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && (constructorRef = ReflectUtil.constructor(clazz2, classArray)) != null) {
                return constructorRef;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                constructorRef = ReflectUtil.constructor(clazz3, classArray);
                if (constructorRef == null) continue;
                ReflectUtil.addConstructorToCache(clazz, constructorRef._constructor);
                return constructorRef;
            }
            return null;
        }
    }

    public static void setAccessible(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (Exception exception) {
            ReflectUtil.setAccessible((Member)field);
        }
    }

    public static void setAccessible(Method method) {
        try {
            method.setAccessible(true);
        }
        catch (Exception exception) {
            ReflectUtil.setAccessible((Member)method);
        }
    }

    public static void setAccessible(Constructor constructor) {
        try {
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            ReflectUtil.setAccessible((Member)constructor);
        }
    }

    public static void setAccessible(Member member) {
        try {
            NecessaryEvilUtil.getUnsafe().putBooleanVolatile(member, _overrideOffset.get(), true);
        }
        catch (Exception exception) {
            throw ManExceptionUtil.unchecked(exception);
        }
    }

    private static MethodRef addMethodToCache(Class clazz, Method method) {
        return ReflectUtil.addMethodToCache(clazz, method, method.getName());
    }

    private static MethodRef addMethodToCache(Class clazz, Method method, String string) {
        ReflectUtil.setAccessible(method);
        ReflectUtil.addRawMethodToCache(clazz, method, string);
        return new MethodRef(method);
    }

    private static void addRawMethodToCache(Class clazz, Method method, String string) {
        ConcurrentHashSet<Method> concurrentHashSet;
        ConcurrentMap<String, ConcurrentHashSet<Method>> concurrentMap = _methodsByName.get(clazz);
        if (concurrentMap == null) {
            concurrentMap = new ConcurrentHashMap<String, ConcurrentHashSet<Method>>();
            _methodsByName.put(clazz, concurrentMap);
        }
        if ((concurrentHashSet = (ConcurrentHashSet<Method>)concurrentMap.get(string)) == null) {
            concurrentHashSet = new ConcurrentHashSet<Method>(2);
            concurrentMap.put(string, concurrentHashSet);
        }
        concurrentHashSet.add(method);
    }

    private static MethodRef getMethodFromCache(Class clazz, String string, Class ... classArray) {
        Method method = ReflectUtil.getRawMethodFromCache(clazz, string, classArray);
        if (method != null) {
            return new MethodRef(method);
        }
        return null;
    }

    private static Method getRawMethodFromCache(Class clazz, String string, Class ... classArray) {
        ConcurrentHashSet concurrentHashSet;
        ConcurrentMap<String, ConcurrentHashSet<Method>> concurrentMap = _methodsByName.get(clazz);
        if (concurrentMap != null && (concurrentHashSet = (ConcurrentHashSet)concurrentMap.get(string)) != null) {
            block0: for (Method method : concurrentHashSet) {
                int n;
                int n2 = n = classArray == null ? 0 : classArray.length;
                if (method.getParameterCount() != n) continue;
                if (n > 0) {
                    Class<?>[] classArray2 = method.getParameterTypes();
                    for (int i = 0; i < classArray2.length; ++i) {
                        Class<?> clazz2 = classArray2[i];
                        if (!clazz2.equals(classArray[i])) continue block0;
                    }
                }
                return method;
            }
        }
        return null;
    }

    private static MethodRef getMethodFromCacheUsingNameOnly(Class clazz, String string) {
        Method method = ReflectUtil.getRawMethodFromCacheUsingNameOnly(clazz, string);
        if (method != null) {
            return new MethodRef(method);
        }
        return null;
    }

    private static Method getRawMethodFromCacheUsingNameOnly(Class clazz, String string) {
        ConcurrentHashSet concurrentHashSet;
        ConcurrentMap<String, ConcurrentHashSet<Method>> concurrentMap = _methodsByName.get(clazz);
        if (concurrentMap != null && (concurrentHashSet = (ConcurrentHashSet)concurrentMap.get(string)) != null) {
            return (Method)concurrentHashSet.iterator().next();
        }
        return null;
    }

    private static ConstructorRef addConstructorToCache(Class clazz, Constructor constructor) {
        ReflectUtil.setAccessible(constructor);
        ReflectUtil.addRawConstructorToCache(clazz, constructor);
        return new ConstructorRef(constructor);
    }

    private static void addRawConstructorToCache(Class clazz2, Constructor constructor) {
        Set set = _constructorsByClass.computeIfAbsent(clazz2, clazz -> ConcurrentHashMap.newKeySet());
        set.add(constructor);
    }

    private static ConstructorRef getConstructorFromCache(Class clazz, Class ... classArray) {
        Constructor constructor = ReflectUtil.getRawConstructorFromCache(clazz, classArray);
        if (constructor != null) {
            return new ConstructorRef(constructor);
        }
        return null;
    }

    private static Constructor getRawConstructorFromCache(Class clazz, Class ... classArray) {
        Set<Constructor> set = _constructorsByClass.get(clazz);
        if (set != null) {
            block0: for (Constructor constructor : set) {
                int n;
                int n2 = n = classArray == null ? 0 : classArray.length;
                if (constructor.getParameterCount() != n) continue;
                Class<?>[] classArray2 = constructor.getParameterTypes();
                if (n > 0) {
                    for (int i = 0; i < classArray2.length; ++i) {
                        Class<?> clazz2 = classArray2[i];
                        if (!clazz2.equals(classArray[i])) continue block0;
                    }
                }
                return constructor;
            }
        }
        return null;
    }

    private static boolean setFinal(Field field, Object object) {
        return ReflectUtil.setFinal(field, null, object);
    }

    private static boolean setFinal(Field field, Object object, Object object2) {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                if (JreUtil.isJava11orLater()) {
                    Object object3 = ReflectUtil.method("jdk.internal.misc.Unsafe", "getUnsafe", new Class[0]).invokeStatic(new Object[0]);
                    LiveMethodRef liveMethodRef = JreUtil.isJava17orLater() ? ReflectUtil.method(object3, "putReference", Object.class, Long.TYPE, Object.class) : ReflectUtil.method(object3, "putObject", Object.class, Long.TYPE, Object.class);
                    liveMethodRef.invoke(object == null ? ReflectUtil.method(object3, "staticFieldBase", Field.class).invoke(field) : object, Modifier.isStatic(field.getModifiers()) ? ReflectUtil.method(object3, "staticFieldOffset", Field.class).invoke(field) : ReflectUtil.method(object3, "objectFieldOffset", Field.class).invoke(field), object2);
                    return true;
                }
                ReflectUtil.clearFieldAccessors(field);
                ReflectUtil.removeFinalModifier(field);
                field.set(object, object2);
                return true;
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
        return false;
    }

    private static void removeFinalModifier(Field field) {
        Field field2 = ReflectUtil.getDeclaredField(Field.class, "modifiers");
        field2.setAccessible(true);
        field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private static void clearFieldAccessors(Field field) {
        Field field2 = ReflectUtil.getDeclaredField(Field.class, "fieldAccessor");
        field2.setAccessible(true);
        field2.set(field, null);
        Field field3 = ReflectUtil.getDeclaredField(Field.class, "overrideFieldAccessor");
        field3.setAccessible(true);
        field3.set(field, null);
        Field field4 = ReflectUtil.getDeclaredField(Field.class, "root");
        field4.setAccessible(true);
        Field field5 = (Field)field4.get(field);
        if (field5 != null) {
            ReflectUtil.clearFieldAccessors(field5);
        }
    }

    private static FieldRef addFieldToCache(Class clazz, Field field) {
        ReflectUtil.setAccessible(field);
        ReflectUtil.addRawFieldToCache(clazz, field);
        return new FieldRef(field);
    }

    private static FieldRef getFieldFromCache(Class clazz, String string) {
        Field field = ReflectUtil.getRawFieldFromCache(clazz, string);
        if (field != null) {
            return new FieldRef(field);
        }
        return null;
    }

    private static void addRawFieldToCache(Class clazz, Field field) {
        ConcurrentMap<String, Field> concurrentMap = _fieldsByName.get(clazz);
        if (concurrentMap == null) {
            concurrentMap = new ConcurrentHashMap<String, Field>();
            _fieldsByName.put(clazz, concurrentMap);
        }
        concurrentMap.put(field.getName(), field);
    }

    private static Field getRawFieldFromCache(Class clazz, String string) {
        ConcurrentMap<String, Field> concurrentMap = _fieldsByName.get(clazz);
        if (concurrentMap != null) {
            return (Field)concurrentMap.get(string);
        }
        return null;
    }

    public static void preloadClassIntoParentLoader(String string, URI uRI, ClassLoader classLoader, ClassLoader classLoader2) {
        if (null != ReflectUtil.method(classLoader2, "findLoadedClass", String.class).invoke(string)) {
            return;
        }
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(uRI));
            ReflectUtil.method(classLoader2, "defineClass", byte[].class, Integer.TYPE, Integer.TYPE).invoke(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static MethodRef structuralMethod(Class clazz, Class clazz2, String string, Class ... classArray) {
        MethodRef methodRef = ReflectUtil.method(clazz2, string, classArray);
        if (methodRef != null) {
            Method method = ReflectUtil.findBestMethod(methodRef.getMethod(), clazz);
            return method == null ? null : new MethodRef(method);
        }
        return null;
    }

    public static LiveMethodRef structuralMethod(Object object, Class clazz, String string, Class ... classArray) {
        MethodRef methodRef = ReflectUtil.method(clazz, string, classArray);
        if (methodRef != null) {
            Method method = ReflectUtil.findBestMethod(methodRef.getMethod(), object.getClass());
            return method == null ? null : new LiveMethodRef(method, object);
        }
        return null;
    }

    public static Object structuralCall(Method method, Object object, Object ... objectArray) {
        return ReflectUtil.structuralCallByProxy(method, null, object, objectArray);
    }

    public static Object structuralCallByProxy(Method method, Object object, Object object2, Object ... objectArray) {
        Method method2 = ReflectUtil.findBestMethod(method, object2.getClass());
        if (method2 == null) {
            if (object != null && method.isDefault()) {
                return ReflectUtil.invokeDefault(object, method, objectArray);
            }
            Object object3 = ReflectUtil.handleByField(method, object, object2, objectArray);
            if (object3 != UNHANDLED) {
                return object3;
            }
            throw new RuntimeException("Receiver type '" + object2.getClass().getTypeName() + "' does not implement a method structurally compatible with method: " + method);
        }
        try {
            return method2.invoke(object2, objectArray);
        }
        catch (Throwable throwable) {
            throw ManExceptionUtil.unchecked(throwable);
        }
    }

    private static Field findField(String string, Class clazz, Class<?> clazz2, Variance variance) {
        String string2 = Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
        String string3 = Character.toLowerCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
        String string4 = '_' + string3;
        for (Field field : clazz.getFields()) {
            Class<?> clazz3;
            String string5 = field.getName();
            Class<?> clazz4 = variance == Variance.Covariant ? clazz2 : field.getType();
            Class<?> clazz5 = clazz3 = variance == Variance.Covariant ? field.getType() : clazz2;
            if (!clazz4.isAssignableFrom(clazz3) && !ReflectUtil.arePrimitiveTypesAssignable(clazz4, clazz3) || !string5.equals(string2) && !string5.equals(string3) && !string5.equals(string4)) continue;
            return field;
        }
        return null;
    }

    public static boolean arePrimitiveTypesAssignable(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == Double.TYPE) {
            return clazz2 == Float.TYPE || clazz2 == Integer.TYPE || clazz2 == Character.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE;
        }
        if (clazz == Float.TYPE) {
            return clazz2 == Character.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE;
        }
        if (clazz == Long.TYPE) {
            return clazz2 == Integer.TYPE || clazz2 == Character.TYPE || clazz2 == Short.TYPE || clazz2 == Byte.TYPE;
        }
        if (clazz == Integer.TYPE) {
            return clazz2 == Short.TYPE || clazz2 == Character.TYPE || clazz2 == Byte.TYPE;
        }
        if (clazz == Short.TYPE) {
            return clazz2 == Byte.TYPE;
        }
        return false;
    }

    private static Object handleByField(Method method, Object object, Object object2, Object[] objectArray) {
        String string = ReflectUtil.getPropertyNameFromGetter(method);
        if (string != null) {
            Field field = ReflectUtil.findField(string, object2.getClass(), method.getReturnType(), Variance.Covariant);
            if (field != null) {
                try {
                    ReflectUtil.setAccessible(field);
                    return field.get(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ManExceptionUtil.unchecked(illegalAccessException);
                }
            }
        } else {
            Field field;
            string = ReflectUtil.getPropertyNameFromSetter(method);
            if (string != null && (field = ReflectUtil.findField(string, object2.getClass(), method.getParameterTypes()[0], Variance.Contravariant)) != null) {
                try {
                    ReflectUtil.setAccessible(field);
                    field.set(object2, objectArray[0]);
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ManExceptionUtil.unchecked(illegalAccessException);
                }
            }
        }
        return UNHANDLED;
    }

    public static Method findBestMethod(Method method2, Class clazz2) {
        ConcurrentMap concurrentMap = _structuralCall.computeIfAbsent(method2, method -> new ConcurrentWeakHashMap());
        return concurrentMap.computeIfAbsent(clazz2, clazz -> {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(method2.getName())) continue;
                arrayList.add(method2);
            }
            List<MethodScore> list = MethodScorer.instance().scoreMethods(arrayList, Arrays.asList(method2.getParameterTypes()), method2.getReturnType());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Method method2;
                MethodScore methodScore = (MethodScore)iterator.next();
                if (methodScore.isErrant()) continue;
                method2 = methodScore.getMethod();
                ReflectUtil.setAccessible(method2);
                return method2;
            }
            return null;
        });
    }

    private static String getPropertyNameFromGetter(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 0) {
            return null;
        }
        String string = method.getName();
        String string2 = null;
        for (String string3 : Arrays.asList("get", "is")) {
            if (string.length() <= string3.length() || !string.startsWith(string3)) continue;
            if (string3.equals("is") && !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) break;
            string2 = string.substring(string3.length());
            char c = string2.charAt(0);
            if (c == '_' && string2.length() > 1) {
                string2 = string2.substring(1);
                continue;
            }
            if (!Character.isAlphabetic(c) || Character.isUpperCase(c)) continue;
            string2 = null;
            break;
        }
        return string2;
    }

    private static String getPropertyNameFromSetter(Method method) {
        if (method.getReturnType() != Void.TYPE) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        String string = method.getName();
        String string2 = null;
        if (string.length() > "set".length() && string.startsWith("set")) {
            string2 = string.substring("set".length());
            char c = string2.charAt(0);
            if (c == '_' && string2.length() > 1) {
                string2 = string2.substring(1);
            } else if (Character.isAlphabetic(c) && !Character.isUpperCase(c)) {
                string2 = null;
            }
        }
        return string2;
    }

    static {
        NecessaryEvilUtil.disableJava9IllegalAccessWarning();
    }

    public static class FakeProxy
    implements InvocationHandler {
        private final Object _arg;

        public FakeProxy(Object object) {
            this._arg = object;
        }

        public Object getTarget() {
            return this._arg;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            throw new IllegalStateException("This proxy exists only to handle being cast, it should never be invoked.");
        }
    }

    static enum Variance {
        Covariant,
        Contravariant;

    }

    static class ClassContextSecurityManager
    extends SecurityManager {
        ClassContextSecurityManager() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    public static class WithNull {
        public static LiveMethodRef method(Object object, String string, Class ... classArray) {
            MethodRef methodRef = ReflectUtil.method(object.getClass(), string, classArray);
            if (methodRef == null) {
                return null;
            }
            return new LiveMethodRef(methodRef._method, object);
        }

        public static LiveFieldRef field(Object object, String string) {
            FieldRef fieldRef = ReflectUtil.field(object.getClass(), string);
            if (fieldRef == null) {
                return null;
            }
            return new LiveFieldRef(fieldRef._field, object);
        }

        public static LiveMethodRef methodWithReturn(Object object, String string, Class<?> clazz, Class ... classArray) {
            LiveMethodRef liveMethodRef = WithNull.method(object, string, classArray);
            if (liveMethodRef != null && !clazz.isAssignableFrom(liveMethodRef.getMethod().getReturnType())) {
                liveMethodRef = null;
            }
            return liveMethodRef;
        }
    }

    public static class ConstructorRef {
        private final Constructor<?> _constructor;

        private ConstructorRef(Constructor<?> constructor) {
            this._constructor = constructor;
        }

        public Object newInstance(Object ... objectArray) {
            try {
                return this._constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public Constructor<?> getConstructor() {
            return this._constructor;
        }
    }

    public static class LiveFieldRef {
        private final Field _field;
        private final Object _receiver;

        private LiveFieldRef(Field field, Object object) {
            this._field = field;
            this._receiver = object;
        }

        public Field getField() {
            return this._field;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object get() {
            try {
                return this._field.get(this._receiver);
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public void set(Object object) {
            try {
                this._field.set(this._receiver, object);
            }
            catch (Exception exception) {
                if (ReflectUtil.setFinal(this._field, this._receiver, object)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.getField().getModifiers());
        }
    }

    public static class FieldRef {
        private final Field _field;

        private FieldRef(Field field) {
            this._field = field;
        }

        public Object get(Object object) {
            try {
                return this._field.get(object);
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public void set(Object object, Object object2) {
            try {
                this._field.set(object, object2);
            }
            catch (Exception exception) {
                if (ReflectUtil.setFinal(this._field, object, object2)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public Object getStatic() {
            try {
                return this._field.get(null);
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public void setStatic(Object object) {
            try {
                this._field.set(null, object);
            }
            catch (Exception exception) {
                if (ReflectUtil.setFinal(this._field, object)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(exception);
            }
        }
    }

    public static class LiveMethodRef {
        private final Method _method;
        private final Object _receiver;

        private LiveMethodRef(Method method, Object object) {
            this._method = method;
            this._receiver = object;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object invoke(Object ... objectArray) {
            try {
                return this._method.invoke(this._receiver, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ManExceptionUtil.unchecked(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public Object invokeSuper(Object ... objectArray) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                ReflectUtil.field(lookup, "lookupClass").set(this._receiver.getClass());
                MethodHandle methodHandle = lookup.findSpecial(this._receiver.getClass().getSuperclass(), this._method.getName(), MethodType.methodType(this._method.getReturnType(), this._method.getParameterTypes()), this._receiver.getClass());
                Object object = ReflectUtil.method(methodHandle, "bindTo", Object.class).invoke(this._receiver);
                return ReflectUtil.method(object, "invokeWithArguments", List.class).invoke(Arrays.asList(objectArray));
            }
            catch (Throwable throwable) {
                throw ManExceptionUtil.unchecked(throwable);
            }
        }
    }

    public static class MethodRef {
        private final Method _method;

        private MethodRef(Method method) {
            this._method = method;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object invoke(Object object, Object ... objectArray) {
            try {
                return this._method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ManExceptionUtil.unchecked(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }

        public Object invokeStatic(Object ... objectArray) {
            try {
                return this._method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ManExceptionUtil.unchecked(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw ManExceptionUtil.unchecked(exception);
            }
        }
    }

    static class FakeAccessibleObject {
        private static final String ACCESS_PERMISSION = "";
        boolean override;

        FakeAccessibleObject() {
        }
    }
}

