/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util;

import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentWeakHashMap;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeAncestry {
    private static TypeAncestry INSTANCE;
    private final Map<Class, Set<Class>> _ancestry = new ConcurrentWeakHashMap<Class, Set<Class>>();

    public static TypeAncestry instance() {
        return INSTANCE == null ? (INSTANCE = new TypeAncestry()) : INSTANCE;
    }

    private TypeAncestry() {
    }

    public Set<Class> getTypesInAncestry(Class clazz2) {
        return this._ancestry.computeIfAbsent(clazz2, clazz -> {
            if (clazz.isArray()) {
                Set<Class> set = TypeAncestry.getAllClassesInClassHierarchyAsIntrinsicTypes(clazz);
                set.addAll(new HashSet<Class>(TypeAncestry.getArrayVersionsOfEachType(this.getTypesInAncestry(clazz.getComponentType()))));
                return Collections.unmodifiableSet(set);
            }
            Set<Class> set = TypeAncestry.getAllClassesInClassHierarchyAsIntrinsicTypes(clazz);
            return Collections.unmodifiableSet(set);
        });
    }

    public static Set<Class> getAllClassesInClassHierarchyAsIntrinsicTypes(Class clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        TypeAncestry.addAllClassesInClassHierarchy(clazz, hashSet);
        hashSet.add(Object.class);
        return hashSet;
    }

    private static void addAllClassesInClassHierarchy(Class clazz, Set<Class> set) {
        Class<?>[] classArray;
        if (!set.add(clazz)) {
            return;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            TypeAncestry.addAllClassesInClassHierarchy(clazz2, set);
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            TypeAncestry.addAllClassesInClassHierarchy(clazz3, set);
        }
    }

    public static Set<Class> getArrayVersionsOfEachType(Set<Class> set) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(Object.class);
        for (Class clazz : set) {
            hashSet.add(Array.newInstance(clazz, 0).getClass());
        }
        return hashSet;
    }
}

