/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util.concurrent;

import com.volmit.adapt.util.manifold.util.ILogger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Cache<K, V> {
    private ConcurrentLinkedHashMap<K, V> _cacheImlp;
    private final Loader<K, V> _loader;
    private final String _name;
    private final int _size;
    private final AtomicInteger _requests = new AtomicInteger();
    private final AtomicInteger _misses = new AtomicInteger();
    private final AtomicInteger _hits = new AtomicInteger();
    private ScheduledFuture<?> _loggingTask;

    public Cache(String string, int n, Loader<K, V> loader) {
        this._name = string;
        this._size = n;
        this.clearCacheImpl();
        this._loader = loader;
    }

    private void clearCacheImpl() {
        this._cacheImlp = new ConcurrentLinkedHashMap(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, this._size, new ConcurrentLinkedHashMap.EvictionListener[0]);
    }

    public V evict(K k) {
        return this._cacheImlp.remove(k);
    }

    public V put(K k, V v) {
        return this._cacheImlp.put(k, v);
    }

    public V get(K k) {
        V v = this._cacheImlp.get(k);
        this._requests.incrementAndGet();
        if (v == null) {
            v = this._loader.load(k);
            this._cacheImlp.put(k, v);
            this._misses.incrementAndGet();
        } else {
            this._hits.incrementAndGet();
        }
        return v;
    }

    public Iterable<V> getCachedValues() {
        return this._cacheImlp.values();
    }

    public int getConfiguredSize() {
        return this._size;
    }

    public int getUtilizedSize() {
        return this._cacheImlp.size();
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getMisses() {
        return this._misses.get();
    }

    public int getHits() {
        return this._hits.get();
    }

    public double getHitRate() {
        int n = this.getRequests();
        int n2 = this.getHits();
        if (n == 0) {
            return 0.0;
        }
        return (double)n2 / (double)n;
    }

    public synchronized Cache<K, V> logEveryNSeconds(int n, final ILogger iLogger) {
        if (this._loggingTask != null) {
            throw new IllegalStateException("Logging for " + this + " is already enabled");
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this._loggingTask = scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                iLogger.info(Cache.this);
            }
        }, n, n, TimeUnit.SECONDS);
        return this;
    }

    public synchronized void stopLogging() {
        if (this._loggingTask != null) {
            this._loggingTask.cancel(false);
        }
    }

    public void clear() {
        this.clearCacheImpl();
        this._hits.set(0);
        this._misses.set(0);
        this._requests.set(0);
    }

    public String toString() {
        return "Cache \"" + this._name + "\"( Hits:" + this.getHits() + ", Misses:" + this.getMisses() + ", Requests:" + this.getRequests() + ", Hit rate:" + BigDecimal.valueOf(this.getHitRate() * 100.0).setScale(2, 1) + "% )";
    }

    public static <K, V> Cache<K, V> make(String string, int n, Loader<K, V> loader) {
        return new Cache<K, V>(string, n, loader);
    }

    static class ConcurrentLinkedHashMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 8350170357874293408L;
        final List<EvictionListener<K, V>> listeners;
        final ConcurrentMap<K, Node<K, V>> data;
        final AtomicInteger capacity;
        final EvictionPolicy policy;
        final AtomicInteger length;
        final Node<K, V> head;
        final Node<K, V> tail;

        public ConcurrentLinkedHashMap(EvictionPolicy evictionPolicy, int n, EvictionListener<K, V> ... evictionListenerArray) {
            this(evictionPolicy, n, 16, evictionListenerArray);
        }

        public ConcurrentLinkedHashMap(EvictionPolicy evictionPolicy, int n, int n2, EvictionListener<K, V> ... evictionListenerArray) {
            if (evictionPolicy == null || n < 0 || n2 <= 0) {
                throw new IllegalArgumentException();
            }
            this.listeners = evictionListenerArray == null ? Collections.emptyList() : Arrays.asList(evictionListenerArray);
            this.data = new ConcurrentHashMap<K, Node<K, V>>(n, 0.75f, n2);
            this.capacity = new AtomicInteger(n);
            this.length = new AtomicInteger();
            this.head = new Node();
            this.tail = new Node();
            this.policy = evictionPolicy;
            this.head.setPrev(this.head);
            this.head.setNext(this.tail);
            this.tail.setPrev(this.head);
            this.tail.setNext(this.tail);
        }

        private boolean isOverflow() {
            return this.length.get() > this.capacity();
        }

        public void setCapacity(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.capacity.set(n);
            while (this.isOverflow()) {
                this.evict();
            }
        }

        public int capacity() {
            return this.capacity.get();
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public void clear() {
            for (Object k : this.keySet()) {
                this.remove(k);
            }
        }

        @Override
        public boolean containsKey(Object object) {
            return this.data.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.data.containsValue(new Node<Object, Object>(null, object));
        }

        private void evict() {
            while (this.isOverflow()) {
                Node<K, V> node = this.poll();
                if (node == null) {
                    return;
                }
                if (this.policy.onEvict(this, node)) {
                    V v = node.getValue();
                    if (v != null) {
                        K k = node.getKey();
                        this.data.remove(k);
                        this.notifyEviction(k, v);
                    }
                    this.length.decrementAndGet();
                    return;
                }
                this.offer(node);
            }
        }

        private void notifyEviction(K k, V v) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                EvictionListener<K, V> evictionListener = this.listeners.get(i);
                evictionListener.onEviction(k, v);
            }
        }

        private Node<K, V> poll() {
            Node.State state;
            Node<K, V> node;
            while (!this.head.casNext(node = this.head.getNext(), node.getNext())) {
            }
            do {
                if (!node.casState(Node.State.LINKED, Node.State.UNLINKING)) continue;
                node.getNext().setPrev(this.head);
                node.setState(Node.State.UNLINKED);
                return node;
            } while ((state = node.getState()) != Node.State.SENTINEL);
            return null;
        }

        private void offer(Node<K, V> node) {
            Node<K, V> node2;
            node.setState(Node.State.LINKING);
            node.setNext(this.tail);
            do {
                node2 = this.tail.getPrev();
                node.setPrev(node2);
            } while (!node2.casNext(this.tail, node));
            Node<K, V> node3 = this.tail;
            while (true) {
                if (node3.casPrev(node2, node)) {
                    node.setState(Node.State.LINKED);
                    return;
                }
                node3 = node3.getPrev();
            }
        }

        private Node<K, V> putIfAbsent(Node<K, V> node) {
            Node<K, V> node2 = this.data.putIfAbsent(node.getKey(), node);
            if (node2 == null) {
                this.length.incrementAndGet();
                this.offer(node);
                this.evict();
            }
            return node2;
        }

        @Override
        public V get(Object object) {
            Node node = (Node)this.data.get(object);
            if (node != null) {
                Object v = node.getValue();
                this.policy.onGet(this, node);
                return v;
            }
            return null;
        }

        @Override
        public V put(K k, V v) {
            if (v == null) {
                throw new IllegalArgumentException();
            }
            Node<K, V> node = this.putIfAbsent(new Node<K, V>(k, v));
            return node == null ? null : (V)node.getAndSetValue(v);
        }

        @Override
        public V putIfAbsent(K k, V v) {
            if (v == null) {
                throw new IllegalArgumentException();
            }
            Node<K, V> node = this.putIfAbsent(new Node<K, V>(k, v));
            return node == null ? null : (V)node.getValue();
        }

        @Override
        public V remove(Object object) {
            Node node = (Node)this.data.remove(object);
            if (node != null) {
                Object v = node.getValue();
                this.policy.onRemove(this, node);
                return v;
            }
            return null;
        }

        @Override
        public boolean remove(Object object, Object object2) {
            Node node = (Node)this.data.get(object);
            if (node != null && node.value.equals(object2) && this.data.remove(object, node)) {
                this.policy.onRemove(this, node);
                return true;
            }
            return false;
        }

        @Override
        public V replace(K k, V v) {
            if (v == null) {
                throw new IllegalArgumentException();
            }
            Node node = (Node)this.data.get(k);
            return node == null ? null : (V)node.getAndSetValue(v);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            if (v2 == null) {
                throw new IllegalArgumentException();
            }
            Node node = (Node)this.data.get(k);
            return node != null && node.casValue(v, v2);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySetAdapter();
        }

        private static final class SimpleEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private V value;

            public SimpleEntry(K k, V v) {
                this.key = k;
                this.value = v;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V v) {
                V v2 = this.value;
                this.value = v;
                return v2;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
            }

            @Override
            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            private static boolean eq(Object object, Object object2) {
                return object == null ? object2 == null : object.equals(object2);
            }
        }

        private final class EntryIteratorAdapter
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, Node<K, V>>> iterator;
            private Map.Entry<K, Node<K, V>> current;

            public EntryIteratorAdapter(Iterator<Map.Entry<K, Node<K, V>>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.current = this.iterator.next();
                Object k = this.current.getKey();
                Node node = this.current.getValue();
                Object v = node == null ? null : (Object)node.getValue();
                return new SimpleEntry(k, v);
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                ConcurrentLinkedHashMap.this.remove(this.current.getKey(), this.current.getValue());
                this.current = null;
            }
        }

        private final class EntrySetAdapter
        extends AbstractSet<Map.Entry<K, V>> {
            private final ConcurrentLinkedHashMap<K, V> map;

            private EntrySetAdapter() {
                this.map = ConcurrentLinkedHashMap.this;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIteratorAdapter(this.map.data.entrySet().iterator());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Node node = (Node)this.map.data.get(entry.getKey());
                return node != null && node.value.equals(entry.getValue());
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return this.map.remove(entry.getKey(), entry.getValue());
            }
        }

        static final class Node<K, V>
        implements Serializable {
            private static final long serialVersionUID = 1461281468985304519L;
            private static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
            private static final AtomicReferenceFieldUpdater<Node, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, State.class, "state");
            private static final AtomicReferenceFieldUpdater<Node, Node> prevUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "prev");
            private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
            private final K key;
            private volatile V value;
            private volatile State state;
            private volatile boolean marked;
            private volatile Node<K, V> prev = null;
            private volatile Node<K, V> next = null;

            public Node() {
                this.key = null;
                this.state = State.SENTINEL;
            }

            public Node(K k, V v) {
                this.key = k;
                this.value = v;
                this.state = State.UNLINKED;
            }

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }

            public void setValue(V v) {
                valueUpdater.set(this, v);
            }

            public V getAndSetValue(V v) {
                return (V)valueUpdater.getAndSet(this, v);
            }

            public boolean casValue(V v, V v2) {
                return valueUpdater.compareAndSet(this, v, v2);
            }

            public Node<K, V> getPrev() {
                return this.prev;
            }

            public void setPrev(Node<K, V> node) {
                prevUpdater.set(this, node);
            }

            public boolean casPrev(Node<K, V> node, Node<K, V> node2) {
                return prevUpdater.compareAndSet(this, node, node2);
            }

            public Node<K, V> getNext() {
                return this.next;
            }

            public void setNext(Node<K, V> node) {
                nextUpdater.set(this, node);
            }

            public boolean casNext(Node<K, V> node, Node<K, V> node2) {
                return nextUpdater.compareAndSet(this, node, node2);
            }

            public boolean isMarked() {
                return this.marked;
            }

            public void setMarked(boolean bl) {
                this.marked = bl;
            }

            public State getState() {
                return this.state;
            }

            public void setState(State state) {
                stateUpdater.set(this, state);
            }

            public boolean casState(State state, State state2) {
                return stateUpdater.compareAndSet(this, state, state2);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Node)) {
                    return false;
                }
                V v = this.getValue();
                Node node = (Node)object;
                return v == null ? node.getValue() == null : v.equals(node.getValue());
            }

            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public String toString() {
                return String.format("Node[state=%s, marked=%b, key=%s, value=%s]", new Object[]{this.getState(), this.isMarked(), this.getKey(), this.getValue()});
            }

            public static enum State {
                SENTINEL,
                UNLINKED,
                UNLINKING,
                LINKING,
                LINKED;

            }
        }

        public static enum EvictionPolicy {
            FIFO{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    return true;
                }
            }
            ,
            SECOND_CHANCE{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    node.setMarked(true);
                }

                @Override
                <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    super.onRemove(concurrentLinkedHashMap, node);
                    node.setMarked(false);
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    if (node.isMarked()) {
                        node.setMarked(false);
                        return false;
                    }
                    return true;
                }
            }
            ,
            LRU{

                @Override
                <K, V> void onGet(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    Node<K, V> node2 = new Node<K, V>(node.getKey(), node.getValue());
                    if (concurrentLinkedHashMap.data.replace(node.getKey(), node, node2)) {
                        concurrentLinkedHashMap.length.incrementAndGet();
                        this.onRemove(concurrentLinkedHashMap, node);
                        ((ConcurrentLinkedHashMap)concurrentLinkedHashMap).offer(node2);
                        ((ConcurrentLinkedHashMap)concurrentLinkedHashMap).evict();
                    }
                }

                @Override
                <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                    return true;
                }
            };


            abstract <K, V> void onGet(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);

            <K, V> void onRemove(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap, Node<K, V> node) {
                node.setValue(null);
            }

            abstract <K, V> boolean onEvict(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);
        }

        public static interface EvictionListener<K, V> {
            public void onEviction(K var1, V var2);
        }
    }

    public static interface Loader<L, W> {
        public W load(L var1);
    }
}

