/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.exception.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.ArgUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionContext
implements Serializable {
    private static final long serialVersionUID = -6024911025449780478L;
    private Throwable throwable;
    private List<Localizable> msgPatterns;
    private List<Object[]> msgArguments;
    private Map<String, Object> context;
    private static final String[] a;

    public ExceptionContext(Throwable throwable) {
        this.throwable = throwable;
        this.msgPatterns = new ArrayList<Localizable>();
        this.msgArguments = new ArrayList<Object[]>();
        this.context = new HashMap<String, Object>();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addMessage(Localizable localizable, Object ... objectArray) {
        this.msgPatterns.add(localizable);
        this.msgArguments.add(ArgUtils.flatten(objectArray));
    }

    public void setValue(String string, Object object) {
        String[] stringArray = LocalizedFormats.b();
        this.context.put(string, object);
        String[] stringArray2 = stringArray;
        if (stringArray2 != null) {
            AdvancedEffect.b(new int[1]);
        }
    }

    public Object getValue(String string) {
        return this.context.get(string);
    }

    public Set<String> getKeys() {
        return this.context.keySet();
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.buildMessage(locale, a[0]);
    }

    public String getMessage(Locale locale, String string) {
        return this.buildMessage(locale, string);
    }

    private String buildMessage(Locale locale, String string) {
        StringBuilder stringBuilder;
        block2: {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            String[] stringArray = LocalizedFormats.b();
            int n2 = this.msgPatterns.size();
            for (int i = 0; i < n2; ++i) {
                Localizable localizable = this.msgPatterns.get(i);
                Object[] objectArray = this.msgArguments.get(i);
                MessageFormat messageFormat = new MessageFormat(localizable.getLocalizedString(locale), locale);
                stringBuilder = stringBuilder2.append(messageFormat.format(objectArray));
                if (stringArray == null) {
                    if (++n >= n2) continue;
                    stringBuilder2.append(string);
                    if (stringArray == null) continue;
                }
                break block2;
            }
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.throwable);
        this.serializeMessages(objectOutputStream);
        this.serializeContext(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.throwable = (Throwable)objectInputStream.readObject();
        this.deSerializeMessages(objectInputStream);
        this.deSerializeContext(objectInputStream);
    }

    private void serializeMessages(ObjectOutputStream objectOutputStream) {
        int n = this.msgPatterns.size();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        String[] stringArray = LocalizedFormats.b();
        block4: while (true) {
            int n3 = n2;
            block5: while (n3 < n) {
                Localizable localizable = this.msgPatterns.get(n2);
                objectOutputStream.writeObject(localizable);
                Object[] objectArray = this.msgArguments.get(n2);
                int n4 = objectArray.length;
                objectOutputStream.writeInt(n4);
                for (int i = 0; i < n4; ++i) {
                    n3 = objectArray[i] instanceof Serializable;
                    if (stringArray != null) continue block5;
                    try {
                        try {
                            if (n3 != 0) {
                                objectOutputStream.writeObject(objectArray[i]);
                                if (stringArray == null) continue;
                            }
                        }
                        catch (IOException iOException) {
                            throw ExceptionContext.b(iOException);
                        }
                        objectOutputStream.writeObject(this.nonSerializableReplacement(objectArray[i]));
                        continue;
                    }
                    catch (IOException iOException) {
                        throw ExceptionContext.b(iOException);
                    }
                }
                ++n2;
                if (stringArray == null) continue block4;
            }
            break;
        }
    }

    private void deSerializeMessages(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        String[] stringArray = LocalizedFormats.b();
        this.msgPatterns = new ArrayList<Localizable>(n);
        this.msgArguments = new ArrayList<Object[]>(n);
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Localizable localizable = (Localizable)objectInputStream.readObject();
                this.msgPatterns.add(localizable);
                int n3 = objectInputStream.readInt();
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    try {
                        objectArray[i] = objectInputStream.readObject();
                        if (stringArray == null) {
                            if (stringArray == null) continue;
                            break;
                        }
                        break block5;
                    }
                    catch (IOException iOException) {
                        throw ExceptionContext.b(iOException);
                    }
                }
                this.msgArguments.add(objectArray);
                ++n2;
            }
            if (stringArray == null) continue;
        }
    }

    private void serializeContext(ObjectOutputStream objectOutputStream) {
        int n = this.context.size();
        String[] stringArray = LocalizedFormats.b();
        objectOutputStream.writeInt(n);
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            block6: {
                objectOutputStream.writeObject(entry.getKey());
                Object object = entry.getValue();
                try {
                    block5: {
                        try {
                            if (!(object instanceof Serializable)) break block5;
                            objectOutputStream.writeObject(object);
                            if (stringArray == null) break block6;
                        }
                        catch (IOException iOException) {
                            throw ExceptionContext.b(iOException);
                        }
                    }
                    objectOutputStream.writeObject(this.nonSerializableReplacement(object));
                }
                catch (IOException iOException) {
                    throw ExceptionContext.b(iOException);
                }
            }
            if (stringArray == null) continue;
        }
    }

    private void deSerializeContext(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        String[] stringArray = LocalizedFormats.b();
        this.context = new HashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            String string = (String)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.context.put(string, object);
            if (stringArray == null) continue;
        }
    }

    private String nonSerializableReplacement(Object object) {
        return a[1] + object.getClass().getName() + "]";
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }

    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "\u0005/!d@}Hs[V\u001flpWz\\\u0002Q`k\u0002t]\u0002LjmKwTKEj{\u00186";
        int n2 = "\u0005/!d@}Hs[V\u001flpWz\\\u0002Q`k\u0002t]\u0002LjmKwTKEj{\u00186".length();
        int n3 = 2;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            Object var6_6 = null;
            stringArray[n++] = ExceptionContext.a(25, ExceptionContext.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        a = stringArray;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x3B);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 38;
                        break;
                    }
                    case 1: {
                        n5 = 22;
                        break;
                    }
                    case 2: {
                        n5 = 6;
                        break;
                    }
                    case 3: {
                        n5 = 59;
                        break;
                    }
                    case 4: {
                        n5 = 15;
                        break;
                    }
                    case 5: {
                        n5 = 33;
                        break;
                    }
                    default: {
                        n5 = 59;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

