/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.libs.apache.commons.math3.Field;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.DimensionMismatchException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathArithmeticException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NoDataException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotANumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NullArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathArrays {
    private MathArrays() {
    }

    public static double[] scale(double d, double[] dArray) {
        double[] dArray2;
        block4: {
            double[] dArray3 = new double[dArray.length];
            int n = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray2 = dArray3;
                    if (n == 0) {
                        dArray2[i] = dArray[i] * d;
                        if (n == 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    public static void scaleInPlace(double d, double[] dArray) {
        int n = 0;
        int n2 = FastMath.c();
        while (n < dArray.length) {
            int n3 = n++;
            dArray[n3] = dArray[n3] * d;
            if (n2 != 0) continue;
        }
    }

    public static double[] ebeAdd(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            int n = FastMath.c();
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            int n2 = n;
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (n2 != 0) {
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + dArray2[i];
                        if (n2 != 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeSubtract(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            int n = FastMath.c();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (n != 0) {
                        int n2 = i;
                        dArray3[n2] = dArray3[n2] - dArray2[i];
                        if (n != 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeMultiply(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            int n = FastMath.c();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (n != 0) {
                        int n2 = i;
                        dArray3[n2] = dArray3[n2] * dArray2[i];
                        if (n != 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeDivide(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            int n = FastMath.c();
            double[] dArray4 = (double[])dArray.clone();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (n != 0) {
                        int n2 = i;
                        dArray3[n2] = dArray3[n2] / dArray2[i];
                        if (n != 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double distance1(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double d2 = 0.0;
            int n = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                d = d2 + FastMath.abs(dArray[i] - dArray2[i]);
                if (n == 0) {
                    d2 = d;
                    if (n == 0) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public static int distance1(int[] nArray, int[] nArray2) {
        int n;
        block2: {
            MathArrays.checkEqualLength(nArray, nArray2);
            int n2 = 0;
            int n3 = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                n = n2 + FastMath.abs(nArray[i] - nArray2[i]);
                if (n3 == 0) {
                    n2 = n;
                    if (n3 == 0) continue;
                }
                break block2;
            }
            n = n2;
        }
        return n;
    }

    public static double distance(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            int n = FastMath.b();
            MathArrays.checkEqualLength(dArray, dArray2);
            double d2 = 0.0;
            int n2 = n;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i] - dArray2[i];
                d = d2 + d3 * d3;
                if (n2 == 0) {
                    d2 = d;
                    if (n2 == 0) continue;
                }
                break block2;
            }
            d = FastMath.sqrt(d2);
        }
        return d;
    }

    public static double cosAngle(double[] dArray, double[] dArray2) {
        return MathArrays.linearCombination(dArray, dArray2) / (MathArrays.safeNorm(dArray) * MathArrays.safeNorm(dArray2));
    }

    public static double distance(int[] nArray, int[] nArray2) {
        double d;
        block2: {
            int n = FastMath.c();
            MathArrays.checkEqualLength(nArray, nArray2);
            int n2 = n;
            double d2 = 0.0;
            for (int i = 0; i < nArray.length; ++i) {
                double d3 = nArray[i] - nArray2[i];
                d = d2 + d3 * d3;
                if (n2 != 0) {
                    d2 = d;
                    if (n2 != 0) continue;
                }
                break block2;
            }
            d = FastMath.sqrt(d2);
        }
        return d;
    }

    public static double distanceInf(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double d2 = 0.0;
            int n = FastMath.c();
            for (int i = 0; i < dArray.length; ++i) {
                d = FastMath.max(d2, FastMath.abs(dArray[i] - dArray2[i]));
                if (n != 0) {
                    d2 = d;
                    if (n != 0) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public static int distanceInf(int[] nArray, int[] nArray2) {
        int n;
        block2: {
            MathArrays.checkEqualLength(nArray, nArray2);
            int n2 = 0;
            int n3 = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                n = FastMath.max(n2, FastMath.abs(nArray[i] - nArray2[i]));
                if (n3 == 0) {
                    n2 = n;
                    if (n3 == 0) continue;
                }
                break block2;
            }
            n = n2;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] var0, OrderDirection var1_1, boolean var2_2) {
        block23: {
            var4_3 = var0[0];
            var5_4 = var0.length;
            var3_5 = FastMath.b();
            for (var6_6 = 1; var6_6 < var5_4; ++var6_6) {
                try {
                    v0 = 3.$SwitchMap$org$apache$commons$math3$util$MathArrays$OrderDirection[var1_1.ordinal()];
                    if (var3_5 != 0) break block23;
                }
                catch (DimensionMismatchException v1) {
                    throw MathArrays.b(v1);
                }
                {
                    ** switch (v0)
                }
lbl-1000:
                // 1 sources

                {
                    case 1: {
                        var7_7 = var4_3.compareTo(var0[var6_6]);
                        try {
                            try {
                                if (var2_2) {
                                    if (var7_7 < 0) break;
                                }
                                ** GOTO lbl25
                            }
                            catch (DimensionMismatchException v2) {
                                throw MathArrays.b(v2);
                            }
                            return false;
                        }
                        catch (DimensionMismatchException v3) {
                            throw MathArrays.b(v3);
                        }
lbl25:
                        // 1 sources

                        try {
                            if (var7_7 > 0) {
                                return false;
                            }
                            break;
                        }
                        catch (DimensionMismatchException v4) {
                            throw MathArrays.b(v4);
                        }
                    }
lbl31:
                    // 1 sources

                    case 2: {
                        var7_7 = var0[var6_6].compareTo(var4_3);
                        try {
                            try {
                                if (var2_2) {
                                    if (var7_7 < 0) break;
                                }
                                ** GOTO lbl44
                            }
                            catch (DimensionMismatchException v5) {
                                throw MathArrays.b(v5);
                            }
                            return false;
                        }
                        catch (DimensionMismatchException v6) {
                            throw MathArrays.b(v6);
                        }
lbl44:
                        // 1 sources

                        try {
                            if (var7_7 > 0) {
                                return false;
                            }
                            break;
                        }
                        catch (DimensionMismatchException v7) {
                            throw MathArrays.b(v7);
                        }
                    }
lbl50:
                    // 1 sources

                    default: {
                        throw new MathInternalError();
                    }
                }
                var4_3 = var0[var6_6];
                if (var3_5 == 0) continue;
            }
            v0 = 1;
        }
        return (boolean)v0;
    }

    public static boolean isMonotonic(double[] dArray, OrderDirection orderDirection, boolean bl) {
        return MathArrays.checkOrder(dArray, orderDirection, bl, false);
    }

    public static boolean checkEqualLength(double[] dArray, double[] dArray2, boolean bl) {
        try {
            if (dArray.length == dArray2.length) {
                return true;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        try {
            if (bl) {
                throw new DimensionMismatchException(dArray.length, dArray2.length);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return false;
    }

    public static void checkEqualLength(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2, true);
    }

    public static boolean checkEqualLength(int[] nArray, int[] nArray2, boolean bl) {
        try {
            if (nArray.length == nArray2.length) {
                return true;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        try {
            if (bl) {
                throw new DimensionMismatchException(nArray.length, nArray2.length);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return false;
    }

    public static void checkEqualLength(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2, true);
    }

    /*
     * Exception decompiling
     */
    public static boolean checkOrder(double[] var0, OrderDirection var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkOrder(double[] dArray, OrderDirection orderDirection, boolean bl) {
        MathArrays.checkOrder(dArray, orderDirection, bl, true);
    }

    public static void checkOrder(double[] dArray) {
        MathArrays.checkOrder(dArray, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] lArray) {
        MathUtils.checkNotNull(lArray);
        int n = FastMath.c();
        for (int i = 1; i < lArray.length; ++i) {
            try {
                if (lArray[i].length == lArray[0].length) continue;
                throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, lArray[i].length, lArray[0].length);
            }
            catch (NullArgumentException nullArgumentException) {
                throw MathArrays.b(nullArgumentException);
            }
        }
    }

    public static void checkPositive(double[] dArray) {
        int n = FastMath.b();
        for (int i = 0; i < dArray.length; ++i) {
            try {
                if (!(dArray[i] <= 0.0)) continue;
                throw new NotStrictlyPositiveException(dArray[i]);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw MathArrays.b(notStrictlyPositiveException);
            }
        }
    }

    public static void checkNotNaN(double[] dArray) {
        int n = FastMath.b();
        for (int i = 0; i < dArray.length; ++i) {
            try {
                if (!Double.isNaN(dArray[i])) continue;
                throw new NotANumberException();
            }
            catch (NotANumberException notANumberException) {
                throw MathArrays.b(notANumberException);
            }
        }
    }

    public static void checkNonNegative(long[] lArray) {
        int n = FastMath.b();
        for (int i = 0; i < lArray.length; ++i) {
            try {
                if (lArray[i] >= 0L) continue;
                throw new NotPositiveException(lArray[i]);
            }
            catch (NotPositiveException notPositiveException) {
                throw MathArrays.b(notPositiveException);
            }
        }
    }

    public static void checkNonNegative(long[][] lArray) {
        int n = 0;
        int n2 = FastMath.c();
        block2: while (true) {
            int n3 = n;
            block3: while (n3 < lArray.length) {
                for (int i = 0; i < lArray[n].length; ++i) {
                    long l = lArray[n][i] - 0L;
                    n3 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    if (n2 == 0) continue block3;
                    try {
                        if (n3 >= 0) continue;
                        throw new NotPositiveException(lArray[n][i]);
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw MathArrays.b(notPositiveException);
                    }
                }
                ++n;
                if (n2 != 0) continue block2;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static double safeNorm(double[] var0) {
        block15: {
            var2_1 = 3.834E-20;
            var4_2 = 1.304E19;
            var6_3 = 0.0;
            var1_4 = FastMath.b();
            var8_5 = 0.0;
            var10_6 = 0.0;
            var12_7 = 0.0;
            var14_8 = 0.0;
            var16_9 = var0.length;
            var18_10 = var4_2 / var16_9;
            for (var20_11 = 0; var20_11 < var0.length; ++var20_11) {
                block17: {
                    block18: {
                        var21_13 = FastMath.abs(var0[var20_11]);
                        try {
                            try {
                                block16: {
                                    try {
                                        try {
                                            v0 = var21_13 == var2_1 ? 0 : (var21_13 < var2_1 ? -1 : 1);
                                            if (var1_4 != 0) break block15;
                                            if (v0 < 0) break block16;
                                        }
                                        catch (DimensionMismatchException v1) {
                                            throw MathArrays.b(v1);
                                        }
                                        if (!(var21_13 > var18_10)) break block17;
                                    }
                                    catch (DimensionMismatchException v2) {
                                        throw MathArrays.b(v2);
                                    }
                                }
                                if (var21_13 > var2_1) {
                                }
                                ** GOTO lbl46
                            }
                            catch (DimensionMismatchException v3) {
                                throw MathArrays.b(v3);
                            }
                            if (!(var21_13 > var12_7)) break block18;
                        }
                        catch (DimensionMismatchException v4) {
                            throw MathArrays.b(v4);
                        }
                        var23_14 = var12_7 / var21_13;
                        var6_3 = 1.0 + var6_3 * var23_14 * var23_14;
                        var12_7 = var21_13;
                        if (var1_4 == 0) continue;
                    }
                    var23_14 = var21_13 / var12_7;
                    var6_3 += var23_14 * var23_14;
                    try {
                        if (var1_4 == 0) continue;
lbl46:
                        // 2 sources

                        if (var21_13 > var14_8) {
                        }
                        ** GOTO lbl56
                    }
                    catch (DimensionMismatchException v5) {
                        throw MathArrays.b(v5);
                    }
                    var23_14 = var14_8 / var21_13;
                    var10_6 = 1.0 + var10_6 * var23_14 * var23_14;
                    var14_8 = var21_13;
                    try {
                        if (var1_4 == 0) continue;
lbl56:
                        // 2 sources

                        if (var21_13 == 0.0) continue;
                    }
                    catch (DimensionMismatchException v6) {
                        throw MathArrays.b(v6);
                    }
                    var23_14 = var21_13 / var14_8;
                    var10_6 += var23_14 * var23_14;
                    if (var1_4 == 0) continue;
                }
                var8_5 += var21_13 * var21_13;
                if (var1_4 == 0) continue;
            }
            v0 = (cfr_temp_0 = var6_3 - 0.0) == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
        }
        var20_12 = v0 != false ? var12_7 * Math.sqrt(var6_3 + var8_5 / var12_7 / var12_7) : (var8_5 == 0.0 ? var14_8 * Math.sqrt(var10_6) : (var8_5 >= var14_8 ? Math.sqrt(var8_5 * (1.0 + var14_8 / var8_5 * (var14_8 * var10_6))) : Math.sqrt(var14_8 * (var8_5 / var14_8 + var14_8 * var10_6))));
        return var20_12;
    }

    public static void sortInPlace(double[] dArray, double[] ... dArray2) {
        MathArrays.sortInPlace(dArray, OrderDirection.INCREASING, dArray2);
    }

    public static void sortInPlace(double[] dArray, OrderDirection orderDirection, double[] ... dArray2) {
        Object object;
        int n;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        block26: {
            Comparator<PairDoubleInteger> comparator;
            ArrayList<PairDoubleInteger> arrayList;
            block25: {
                block24: {
                    n4 = FastMath.c();
                    try {
                        if (dArray == null) {
                            throw new NullArgumentException();
                        }
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                    n3 = dArray2.length;
                    n2 = dArray.length;
                    for (int i = 0; i < n3; ++i) {
                        double[] dArray3 = dArray2[i];
                        try {
                            if (dArray3 == null) {
                                throw new NullArgumentException();
                            }
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                        try {
                            if (dArray3.length == n2) continue;
                            throw new DimensionMismatchException(dArray3.length, n2);
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                    }
                    arrayList = new ArrayList<PairDoubleInteger>(n2);
                    for (int i = 0; i < n2; ++i) {
                        try {
                            arrayList.add(new PairDoubleInteger(dArray[i], i));
                            if (n4 != 0) {
                                if (n4 != 0) continue;
                                break;
                            }
                            break block24;
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                    }
                    try {
                        if (orderDirection != OrderDirection.INCREASING) break block24;
                        comparator = new Comparator<PairDoubleInteger>(){

                            @Override
                            public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                                return Double.compare(pairDoubleInteger.getKey(), pairDoubleInteger2.getKey());
                            }
                        };
                        break block25;
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                }
                comparator = new Comparator<PairDoubleInteger>(){

                    @Override
                    public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                        return Double.compare(pairDoubleInteger2.getKey(), pairDoubleInteger.getKey());
                    }
                };
            }
            Comparator<PairDoubleInteger> comparator2 = comparator;
            Collections.sort(arrayList, comparator2);
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                object = (PairDoubleInteger)arrayList.get(n);
                try {
                    dArray[n] = ((PairDoubleInteger)object).getKey();
                    nArray[n] = ((PairDoubleInteger)object).getValue();
                    if (n4 != 0) {
                        if (n4 != 0) continue;
                        break;
                    }
                    break block26;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw MathArrays.b(nullArgumentException);
                }
            }
            n = 0;
        }
        while (n < n3) {
            block27: {
                object = dArray2[n];
                double[] dArray4 = (double[])object.clone();
                for (int i = 0; i < n2; ++i) {
                    try {
                        object[i] = dArray4[nArray[i]];
                        if (n4 != 0) {
                            if (n4 != 0) continue;
                            break;
                        }
                        break block27;
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                }
                ++n;
            }
            if (n4 != 0) continue;
        }
    }

    public static int[] copyOf(int[] nArray) {
        return MathArrays.copyOf(nArray, nArray.length);
    }

    public static double[] copyOf(double[] dArray) {
        return MathArrays.copyOf(dArray, dArray.length);
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, FastMath.min(n, nArray.length));
        return nArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, FastMath.min(n, dArray.length));
        return dArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        int n3 = n2 - n;
        double[] dArray2 = new double[n3];
        System.arraycopy(dArray, n, dArray2, 0, FastMath.min(n3, dArray.length - n));
        return dArray2;
    }

    public static double linearCombination(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        block12: {
            double d4;
            double d5;
            double[] dArray3;
            block11: {
                int n3 = FastMath.c();
                MathArrays.checkEqualLength(dArray, dArray2);
                n2 = n3;
                n = dArray.length;
                try {
                    if (n == 1) {
                        return dArray[0] * dArray2[0];
                    }
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                dArray3 = new double[n];
                d5 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d6 = dArray[i];
                    double d7 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L);
                    double d8 = d6 - d7;
                    double d9 = dArray2[i];
                    double d10 = Double.longBitsToDouble(Double.doubleToRawLongBits(d9) & 0xFFFFFFFFF8000000L);
                    double d11 = d9 - d10;
                    dArray3[i] = d6 * d9;
                    double d12 = d8 * d11 - (dArray3[i] - d7 * d10 - d8 * d10 - d7 * d11);
                    d4 = d5 + d12;
                    if (n2 != 0) {
                        d5 = d4;
                        if (n2 != 0) continue;
                    }
                    break block11;
                }
                d4 = dArray3[0];
            }
            double d13 = d4;
            double d14 = dArray3[1];
            double d15 = d13 + d14;
            double d16 = d15 - d14;
            double d17 = d14 - (d15 - d16) + (d13 - d16);
            int n4 = n - 1;
            for (int i = 1; i < n4; ++i) {
                d14 = dArray3[i + 1];
                double d18 = d15 + d14;
                d16 = d18 - d14;
                d17 += d14 - (d18 - d16) + (d15 - d16);
                d3 = d18;
                if (n2 != 0) {
                    d15 = d3;
                    if (n2 != 0) continue;
                }
                break block12;
            }
            d3 = d15 + (d5 + d17);
        }
        if (Double.isNaN(d2 = d3)) {
            d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                d = d2 + dArray[i] * dArray2[i];
                if (n2 != 0) {
                    d2 = d;
                    if (n2 != 0) continue;
                }
                break;
            }
        } else {
            d = d2;
        }
        return d;
    }

    public static double linearCombination(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = d * d2;
        double d15 = d3 * d4;
        double d16 = d14 + d15;
        double d17 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d18 = d - d17;
        double d19 = d18 * (d13 = d2 - (d12 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L))) - (d14 - d17 * d12 - d18 * d12 - d17 * d13);
        double d20 = d16 + (d19 + (d11 = (d10 = d3 - (d9 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L))) * (d8 = d4 - (d7 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L))) - (d15 - d9 * d7 - d10 * d7 - d9 * d8)) + (d6 = d15 - (d16 - (d5 = d16 - d15)) + (d14 - d5)));
        if (Double.isNaN(d20)) {
            d20 = d * d2 + d3 * d4;
        }
        return d20;
    }

    public static double linearCombination(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d15 = d - d14;
        double d16 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d17 = d2 - d16;
        double d18 = d * d2;
        double d19 = d15 * d17 - (d18 - d14 * d16 - d15 * d16 - d14 * d17);
        double d20 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L);
        double d21 = d3 - d20;
        double d22 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L);
        int n = FastMath.c();
        double d23 = d3 * d4;
        double d24 = d18 + d23;
        double d25 = d5 * d6;
        double d26 = d24 + d25;
        double d27 = d4 - d22;
        double d28 = d21 * d27 - (d23 - d20 * d22 - d21 * d22 - d20 * d27);
        double d29 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L);
        double d30 = d5 - d29;
        double d31 = d30 * (d13 = d6 - (d12 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L))) - (d25 - d29 * d12 - d30 * d12 - d29 * d13);
        double d32 = d26 + (d19 + d28 + d31 + (d11 = d23 - (d24 - (d10 = d24 - d23)) + (d18 - d10)) + (d9 = d25 - (d26 - (d8 = d26 - d25)) + (d24 - d8)));
        if (Double.isNaN(d32)) {
            d32 = d * d2 + d3 * d4 + d5 * d6;
        }
        try {
            d7 = d32;
            if (AdvancedEffect.b() == null) {
                FastMath.b(++n);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return d7;
    }

    public static double linearCombination(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d24 = d - d23;
        double d25 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d26 = d2 - d25;
        double d27 = d * d2;
        double d28 = d24 * d26 - (d27 - d23 * d25 - d24 * d25 - d23 * d26);
        double d29 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L);
        double d30 = d3 - d29;
        double d31 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L);
        int n = FastMath.c();
        double d32 = d3 * d4;
        double d33 = d27 + d32;
        double d34 = d5 * d6;
        double d35 = d33 + d34;
        double d36 = d7 * d8;
        double d37 = d35 + d36;
        double d38 = d4 - d31;
        double d39 = d30 * d38 - (d32 - d29 * d31 - d30 * d31 - d29 * d38);
        double d40 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L);
        double d41 = d5 - d40;
        double d42 = d41 * (d22 = d6 - (d21 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L))) - (d34 - d40 * d21 - d41 * d21 - d40 * d22);
        double d43 = d37 + (d28 + d39 + d42 + (d20 = (d19 = d7 - (d18 = Double.longBitsToDouble(Double.doubleToRawLongBits(d7) & 0xFFFFFFFFF8000000L))) * (d17 = d8 - (d16 = Double.longBitsToDouble(Double.doubleToRawLongBits(d8) & 0xFFFFFFFFF8000000L))) - (d36 - d18 * d16 - d19 * d16 - d18 * d17)) + (d15 = d32 - (d33 - (d14 = d33 - d32)) + (d27 - d14)) + (d13 = d34 - (d35 - (d12 = d35 - d34)) + (d33 - d12)) + (d11 = d36 - (d37 - (d10 = d37 - d36)) + (d35 - d10)));
        if (Double.isNaN(d43)) {
            d43 = d * d2 + d3 * d4 + d5 * d6 + d7 * d8;
        }
        try {
            d9 = d43;
            if (n == 0) {
                AdvancedEffect.b(new int[3]);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return d9;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        boolean bl;
        block21: {
            int n;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        n = FastMath.b();
                        try {
                            try {
                                try {
                                    if (fArray != null && fArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (fArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = fArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (fArray.length != fArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < fArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equals(fArray[i], fArray2[i]);
                        if (n != 0) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(float[] fArray, float[] fArray2) {
        boolean bl;
        block21: {
            int n;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        n = FastMath.c();
                        try {
                            try {
                                try {
                                    if (fArray != null && fArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (fArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = fArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (fArray.length != fArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < fArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equalsIncludingNaN(fArray[i], fArray2[i]);
                        if (n == 0) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        boolean bl;
        block21: {
            int n;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        n = FastMath.c();
                        try {
                            try {
                                try {
                                    if (dArray != null && dArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (dArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = dArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (dArray.length != dArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equals(dArray[i], dArray2[i]);
                        if (n == 0) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(double[] dArray, double[] dArray2) {
        boolean bl;
        block21: {
            int n;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        n = FastMath.c();
                        try {
                            try {
                                try {
                                    if (dArray != null && dArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (dArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = dArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (dArray.length != dArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equalsIncludingNaN(dArray[i], dArray2[i]);
                        if (n == 0) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static double[] normalizeArray(double[] dArray, double d) {
        double[] dArray2;
        block23: {
            double d2;
            int n;
            double[] dArray3;
            int n2;
            double d3;
            int n3;
            block21: {
                double d4;
                n3 = FastMath.b();
                try {
                    if (Double.isInfinite(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (Double.isNaN(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                d3 = 0.0;
                n2 = dArray.length;
                dArray3 = new double[n2];
                for (n = 0; n < n2; ++n) {
                    block22: {
                        try {
                            try {
                                d2 = (double)Double.isInfinite(dArray[n]);
                                if (n3 != 0) break block21;
                                if (d2 == false) break block22;
                            }
                            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                                throw MathArrays.b(mathIllegalArgumentException);
                            }
                            throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, dArray[n], n);
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                    }
                    if (Double.isNaN(dArray[n])) continue;
                    d3 += dArray[n];
                    if (n3 == 0) continue;
                }
                d2 = (d4 = d3 - 0.0) == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
            }
            try {
                if (d2 == false) {
                    throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            for (n = 0; n < n2; ++n) {
                try {
                    block24: {
                        try {
                            try {
                                dArray2 = dArray;
                                if (n3 != 0) break block23;
                                if (!Double.isNaN(dArray2[n])) break block24;
                            }
                            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                                throw MathArrays.b(mathIllegalArgumentException);
                            }
                            dArray3[n] = Double.NaN;
                            if (n3 == 0) continue;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                    }
                    dArray3[n] = dArray[n] * d / d3;
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    public static <T> T[] buildArray(Field<T> field, int n) {
        Object[] objectArray = (Object[])Array.newInstance(field.getRuntimeClass(), n);
        Arrays.fill(objectArray, field.getZero());
        return objectArray;
    }

    public static <T> T[][] buildArray(Field<T> field, int n, int n2) {
        Object[][] objectArray;
        block5: {
            Object[][] objectArray2;
            block7: {
                int n3;
                block6: {
                    n3 = FastMath.b();
                    if (n2 >= 0) break block6;
                    T[] TArray = MathArrays.buildArray(field, 0);
                    objectArray2 = (Object[][])Array.newInstance(TArray.getClass(), n);
                    if (n3 == 0) break block7;
                }
                objectArray2 = (Object[][])Array.newInstance(field.getRuntimeClass(), n, n2);
                for (int i = 0; i < n; ++i) {
                    try {
                        objectArray = objectArray2;
                        if (n3 == 0) {
                            Arrays.fill(objectArray[i], field.getZero());
                            if (n3 == 0) continue;
                            break;
                        }
                        break block5;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                }
            }
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public static double[] convolve(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        block7: {
            int n4 = FastMath.c();
            MathUtils.checkNotNull(dArray);
            n3 = n4;
            MathUtils.checkNotNull(dArray2);
            n2 = dArray.length;
            n = dArray2.length;
            try {
                try {
                    if (n2 != 0 && n != 0) break block7;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw MathArrays.b(nullArgumentException);
                }
                throw new NoDataException();
            }
            catch (NullArgumentException nullArgumentException) {
                throw MathArrays.b(nullArgumentException);
            }
        }
        int n5 = n2 + n - 1;
        double[] dArray3 = new double[n5];
        int n6 = 0;
        block4: while (true) {
            int n7 = n6;
            block5: while (n7 < n5) {
                double d = 0.0;
                int n8 = FastMath.max(0, n6 + 1 - n2);
                int n9 = n6 - n8;
                while (n8 < n) {
                    n7 = n9;
                    if (n3 == 0) continue block5;
                    if (n7 < 0) break;
                    d += dArray[n9--] * dArray2[n8++];
                    if (n3 != 0) continue;
                }
                dArray3[n6] = d;
                ++n6;
                if (n3 != 0) continue block4;
            }
            break;
        }
        return dArray3;
    }

    public static void shuffle(int[] nArray, int n, Position position) {
        MathArrays.shuffle(nArray, n, position, new Well19937c());
    }

    /*
     * Exception decompiling
     */
    public static void shuffle(int[] var0, int var1_1, Position var2_2, RandomGenerator var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void shuffle(int[] nArray, RandomGenerator randomGenerator) {
        MathArrays.shuffle(nArray, 0, Position.TAIL, randomGenerator);
    }

    public static void shuffle(int[] nArray) {
        MathArrays.shuffle(nArray, new Well19937c());
    }

    public static int[] natural(int n) {
        return MathArrays.sequence(n, 0, 1);
    }

    public static int[] sequence(int n, int n2, int n3) {
        int[] nArray;
        block4: {
            int[] nArray2 = new int[n];
            int n4 = FastMath.b();
            for (int i = 0; i < n; ++i) {
                try {
                    nArray = nArray2;
                    if (n4 == 0) {
                        nArray[i] = n2 + i * n3;
                        if (n4 == 0) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public static boolean verifyValues(double[] dArray, int n, int n2) {
        return MathArrays.verifyValues(dArray, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, int n, int n2, boolean bl) {
        block16: {
            try {
                if (dArray == null) {
                    throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n < 0) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n2 < 0) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n + n2 > dArray.length) {
                    throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n + n2), dArray.length, true);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                try {
                    if (n2 != 0 || bl) break block16;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                return false;
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
        }
        return true;
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2) {
        return MathArrays.verifyValues(dArray, dArray2, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2, boolean bl) {
        boolean bl2;
        block21: {
            int n3;
            block20: {
                n3 = FastMath.c();
                try {
                    try {
                        if (dArray2 != null && dArray != null) break block20;
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw MathArrays.b(mathIllegalArgumentException);
                    }
                    throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
            }
            MathArrays.checkEqualLength(dArray2, dArray);
            boolean bl3 = false;
            for (int i = n; i < n + n2; ++i) {
                double d;
                block22: {
                    d = dArray2[i];
                    try {
                        try {
                            bl2 = Double.isNaN(d);
                            if (n3 == 0) break block21;
                            if (!bl2) break block22;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                        throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw MathArrays.b(mathIllegalArgumentException);
                    }
                }
                try {
                    if (Double.isInfinite(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, d, i);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (d < 0.0) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, d);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (bl3 || !(d > 0.0)) continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                bl3 = true;
                if (n3 != 0) continue;
            }
            bl2 = bl3;
        }
        try {
            if (!bl2) {
                throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw MathArrays.b(mathIllegalArgumentException);
        }
        return MathArrays.verifyValues(dArray, n, n2, bl);
    }

    public static double[] concatenate(double[] ... dArray) {
        double[] dArray2;
        block5: {
            int n;
            int n2;
            int n3;
            block4: {
                n3 = 0;
                n2 = FastMath.c();
                for (double[] dArray3 : dArray) {
                    n = n3 + dArray3.length;
                    if (n2 != 0) {
                        n3 = n;
                        if (n2 != 0) continue;
                    }
                    break block4;
                }
                n = 0;
            }
            int n4 = n;
            int n5 = 0;
            double[] dArray4 = new double[n3];
            for (int i = 0; i < dArray.length; ++i) {
                n5 = dArray[i].length;
                dArray2 = dArray[i];
                if (n2 != 0) {
                    System.arraycopy(dArray2, 0, dArray4, n4, n5);
                    n4 += n5;
                    if (n2 != 0) continue;
                }
                break block5;
            }
            dArray2 = dArray4;
        }
        return dArray2;
    }

    public static double[] unique(double[] dArray) {
        double[] dArray2;
        block9: {
            int n;
            int n2;
            TreeSet<Double> treeSet;
            block8: {
                treeSet = new TreeSet<Double>();
                n2 = FastMath.c();
                for (n = 0; n < dArray.length; ++n) {
                    try {
                        treeSet.add(dArray[n]);
                        if (n2 != 0) {
                            if (n2 != 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                }
                n = treeSet.size();
            }
            double[] dArray3 = new double[n];
            Iterator iterator = treeSet.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                try {
                    dArray2 = dArray3;
                    if (n2 != 0) {
                        dArray2[n - ++n3] = (Double)iterator.next();
                        if (n2 != 0) continue;
                        break;
                    }
                    break block9;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    private static MathIllegalArgumentException b(MathIllegalArgumentException mathIllegalArgumentException) {
        return mathIllegalArgumentException;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$commons$math3$util$MathArrays$OrderDirection;
        static final /* synthetic */ int[] $SwitchMap$org$apache$commons$math3$util$MathArrays$Position;

        static {
            $SwitchMap$org$apache$commons$math3$util$MathArrays$Position = new int[Position.values().length];
            try {
                3.$SwitchMap$org$apache$commons$math3$util$MathArrays$Position[Position.TAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$commons$math3$util$MathArrays$Position[Position.HEAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$org$apache$commons$math3$util$MathArrays$OrderDirection = new int[OrderDirection.values().length];
            try {
                3.$SwitchMap$org$apache$commons$math3$util$MathArrays$OrderDirection[OrderDirection.INCREASING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$commons$math3$util$MathArrays$OrderDirection[OrderDirection.DECREASING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position HEAD;
        public static final /* enum */ Position TAIL;
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "cp~c\u0004\u007ftvk";
            int n2 = "cp~c\u0004\u007ftvk".length();
            int n3 = 4;
            int n4 = -1;
            while (true) {
                int n5 = ++n4;
                Object var7_6 = null;
                stringArray[n++] = Position.a(108, Position.a(string.substring(n5, n5 + n3)));
                if ((n4 += n3) >= n2) break;
                n3 = string.charAt(n4);
            }
            String[] stringArray2 = stringArray;
            HEAD = new Position();
            TAIL = new Position();
            $VALUES = new Position[]{HEAD, TAIL};
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x23);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 71;
                            break;
                        }
                        case 1: {
                            n5 = 89;
                            break;
                        }
                        case 2: {
                            n5 = 83;
                            break;
                        }
                        case 3: {
                            n5 = 75;
                            break;
                        }
                        case 4: {
                            n5 = 81;
                            break;
                        }
                        case 5: {
                            n5 = 8;
                            break;
                        }
                        default: {
                            n5 = 35;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }

    private static class PairDoubleInteger {
        private final double key;
        private final int value;

        PairDoubleInteger(double d, int n) {
            this.key = d;
            this.value = n;
        }

        public double getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrderDirection
    extends Enum<OrderDirection> {
        public static final /* enum */ OrderDirection INCREASING;
        public static final /* enum */ OrderDirection DECREASING;
        private static final /* synthetic */ OrderDirection[] $VALUES;

        public static OrderDirection[] values() {
            return (OrderDirection[])$VALUES.clone();
        }

        public static OrderDirection valueOf(String string) {
            return Enum.valueOf(OrderDirection.class, string);
        }

        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "/\tR@ *x/\tV\n\"\u0002R@ *x/\tV";
            int n2 = "/\tR@ *x/\tV\n\"\u0002R@ *x/\tV".length();
            int n3 = 10;
            int n4 = -1;
            while (true) {
                int n5 = ++n4;
                Object var7_6 = null;
                stringArray[n++] = OrderDirection.a(91, OrderDirection.a(string.substring(n5, n5 + n3)));
                if ((n4 += n3) >= n2) break;
                n3 = string.charAt(n4);
            }
            String[] stringArray2 = stringArray;
            INCREASING = new OrderDirection();
            DECREASING = new OrderDirection();
            $VALUES = new OrderDirection[]{INCREASING, DECREASING};
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x70);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 61;
                            break;
                        }
                        case 1: {
                            n5 = 28;
                            break;
                        }
                        case 2: {
                            n5 = 74;
                            break;
                        }
                        case 3: {
                            n5 = 73;
                            break;
                        }
                        case 4: {
                            n5 = 62;
                            break;
                        }
                        case 5: {
                            n5 = 48;
                            break;
                        }
                        default: {
                            n5 = 112;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

