/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.enchanthandler.enchantments;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.ae.enchanthandler.enchantments.AdvancedEnchantment;
import net.advancedplugins.ae.enchanthandler.enchantments.AdvancedGroup;
import net.advancedplugins.ae.impl.effects.effects.EffectsHandler;
import net.advancedplugins.ae.impl.effects.effects.actions.AdvancedTrigger;

public class AEnchants {
    private static final LinkedHashMap<String, AdvancedEnchantment> ENCHANTS_LIST = new LinkedHashMap();
    private static final LinkedHashMap<String, LinkedList<String>> ENCHANT_TYPE_LIST = new LinkedHashMap();
    private static final LinkedHashMap<AdvancedGroup, LinkedList<AdvancedEnchantment>> GROUP_LIST = new LinkedHashMap();

    public static LinkedList<String> getTypeList(String string) {
        return ENCHANT_TYPE_LIST.get(string);
    }

    public static LinkedList<AdvancedEnchantment> getGroupList(AdvancedGroup advancedGroup) {
        return GROUP_LIST.getOrDefault(advancedGroup, new LinkedList());
    }

    public static LinkedList<String> getEnchants() {
        return new LinkedList<String>(ENCHANTS_LIST.keySet());
    }

    public static AdvancedEnchantment matchEnchant(String string) {
        return ENCHANTS_LIST.get(string);
    }

    public static Collection<AdvancedEnchantment> getEnchantTypeList() {
        return ENCHANTS_LIST.values();
    }

    public static AdvancedEnchantment getRandomEnchant(AdvancedGroup advancedGroup) {
        return AEnchants.getGroupList(advancedGroup).get(ThreadLocalRandom.current().nextInt(AEnchants.getGroupList(advancedGroup).size()));
    }

    public static void register(AdvancedEnchantment advancedEnchantment) {
        ENCHANTS_LIST.put(advancedEnchantment.getPath(), advancedEnchantment);
        int[] nArray = AdvancedGroup.b();
        for (String object2 : advancedEnchantment.getTypes()) {
            LinkedList<String> linkedList = AEnchants.getTypeList(object2);
            linkedList.add(advancedEnchantment.getPath());
            if (nArray != null) continue;
        }
        AdvancedGroup advancedGroup = advancedEnchantment.getGroup();
        LinkedList<AdvancedEnchantment> linkedList = GROUP_LIST.getOrDefault(advancedGroup, new LinkedList());
        linkedList.add(advancedEnchantment);
        GROUP_LIST.put(advancedGroup, linkedList);
    }

    public static void clear() {
        ENCHANTS_LIST.clear();
        ENCHANT_TYPE_LIST.forEach((string, linkedList) -> ENCHANT_TYPE_LIST.put((String)string, new LinkedList()));
        GROUP_LIST.clear();
    }

    static {
        if (ENCHANT_TYPE_LIST.isEmpty()) {
            for (AdvancedTrigger advancedTrigger : EffectsHandler.getTriggerHandler().getTriggers()) {
                ENCHANT_TYPE_LIST.put(advancedTrigger.getTriggerName(), new LinkedList());
            }
        }
    }
}

