/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.BetaDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.BinomialDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.CauchyDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.ChiSquaredDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.ExponentialDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.FDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.GammaDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.HypergeometricDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.PascalDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.PoissonDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.TDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.UniformIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.WeibullDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.ZipfDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotANumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotFiniteNumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.BitsStreamGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomData;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGeneratorFactory;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataGenerator
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private RandomGenerator secRand = null;
    private static final String a;

    public RandomDataGenerator() {
    }

    public RandomDataGenerator(RandomGenerator randomGenerator) {
        this.rand = randomGenerator;
    }

    @Override
    public String nextHexString(int n) throws NotStrictlyPositiveException {
        String string;
        block6: {
            String string2 = BitsStreamGenerator.b();
            try {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw RandomDataGenerator.b(notStrictlyPositiveException);
            }
            RandomGenerator randomGenerator = this.getRandomGenerator();
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[n / 2 + 1];
            randomGenerator.nextBytes(byArray);
            for (int i = 0; i < byArray.length; ++i) {
                String string3;
                block7: {
                    Integer n2 = byArray[i];
                    string3 = Integer.toHexString(n2 + 128);
                    try {
                        string = string3;
                        if (string2 == null) break block6;
                        if (string.length() != 1) break block7;
                    }
                    catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                        throw RandomDataGenerator.b(notStrictlyPositiveException);
                    }
                    string3 = "0" + string3;
                }
                stringBuilder.append(string3);
                if (string2 != null) continue;
            }
            string = stringBuilder.toString().substring(0, n);
        }
        return string;
    }

    @Override
    public int nextInt(int n, int n2) throws NumberIsTooLargeException {
        return new UniformIntegerDistribution(this.getRandomGenerator(), n, n2).sample();
    }

    @Override
    public long nextLong(long l, long l2) throws NumberIsTooLargeException {
        String string = BitsStreamGenerator.b();
        try {
            if (l >= l2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l, l2, false);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        long l3 = l2 - l + 1L;
        if (l3 <= 0L) {
            RandomGenerator randomGenerator = this.getRandomGenerator();
            do {
                long l4;
                if ((l4 = randomGenerator.nextLong()) < l) continue;
                try {
                    if (l4 <= l2) {
                        return l4;
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
            } while (string != null);
        }
        try {
            if (l3 < Integer.MAX_VALUE) {
                return l + (long)this.getRandomGenerator().nextInt((int)l3);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        return l + RandomDataGenerator.nextLong(this.getRandomGenerator(), l3);
    }

    private static long nextLong(RandomGenerator randomGenerator, long l) throws IllegalArgumentException {
        String string = BitsStreamGenerator.b();
        if (l > 0L) {
            long l2;
            byte[] byArray = new byte[8];
            block2: while (true) {
                long l3;
                block7: {
                    randomGenerator.nextBytes(byArray);
                    l3 = 0L;
                    for (byte by : byArray) {
                        l3 = l3 << 8 | (long)by & 0xFFL;
                        try {
                            if (string != null) {
                                if (string != null) continue;
                                break;
                            }
                            break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw RandomDataGenerator.b(illegalArgumentException);
                        }
                    }
                    l3 &= Long.MAX_VALUE;
                }
                long l4 = l3 % l;
                l2 = l3 - l4 + (l - 1L);
                do {
                    if (l2 < 0L) continue block2;
                    l2 = l4;
                } while (string == null);
                break;
            }
            return l2;
        }
        throw new NotStrictlyPositiveException(l);
    }

    @Override
    public String nextSecureHexString(int n) throws NotStrictlyPositiveException {
        String string = BitsStreamGenerator.b();
        try {
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw RandomDataGenerator.b(noSuchAlgorithmException);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(a);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MathInternalError(noSuchAlgorithmException);
        }
        messageDigest.reset();
        int n2 = n / 40 + 1;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 1;
        block4: while (true) {
            int n4 = n3;
            int n5 = n2 + 1;
            block5: while (n4 < n5) {
                byte[] byArray = new byte[40];
                randomGenerator.nextBytes(byArray);
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                for (int i = 0; i < byArray2.length; ++i) {
                    Integer n6 = byArray2[i];
                    String string2 = Integer.toHexString(n6 + 128);
                    n4 = string2.length();
                    n5 = 1;
                    if (string == null) continue block5;
                    if (n4 == n5) {
                        string2 = "0" + string2;
                    }
                    stringBuilder.append(string2);
                    if (string != null) continue;
                }
                ++n3;
                if (string != null) continue block4;
            }
            break;
        }
        return stringBuilder.toString().substring(0, n);
    }

    @Override
    public int nextSecureInt(int n, int n2) throws NumberIsTooLargeException {
        return new UniformIntegerDistribution(this.getSecRan(), n, n2).sample();
    }

    @Override
    public long nextSecureLong(long l, long l2) throws NumberIsTooLargeException {
        String string = BitsStreamGenerator.b();
        try {
            if (l >= l2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l, l2, false);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        long l3 = l2 - l + 1L;
        if (l3 <= 0L) {
            do {
                long l4;
                if ((l4 = randomGenerator.nextLong()) < l) continue;
                try {
                    if (l4 <= l2) {
                        return l4;
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
            } while (string != null);
        }
        try {
            if (l3 < Integer.MAX_VALUE) {
                return l + (long)randomGenerator.nextInt((int)l3);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        return l + RandomDataGenerator.nextLong(randomGenerator, l3);
    }

    @Override
    public long nextPoisson(double d) throws NotStrictlyPositiveException {
        return new PoissonDistribution(this.getRandomGenerator(), d, 1.0E-12, 10000000).sample();
    }

    @Override
    public double nextGaussian(double d, double d2) throws NotStrictlyPositiveException {
        try {
            if (d2 <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d2);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw RandomDataGenerator.b(notStrictlyPositiveException);
        }
        return d2 * this.getRandomGenerator().nextGaussian() + d;
    }

    @Override
    public double nextExponential(double d) throws NotStrictlyPositiveException {
        return new ExponentialDistribution(this.getRandomGenerator(), d, 1.0E-9).sample();
    }

    public double nextGamma(double d, double d2) throws NotStrictlyPositiveException {
        return new GammaDistribution(this.getRandomGenerator(), d, d2, 1.0E-9).sample();
    }

    public int nextHypergeometric(int n, int n2, int n3) throws NotPositiveException, NotStrictlyPositiveException, NumberIsTooLargeException {
        return new HypergeometricDistribution(this.getRandomGenerator(), n, n2, n3).sample();
    }

    public int nextPascal(int n, double d) throws NotStrictlyPositiveException, OutOfRangeException {
        return new PascalDistribution(this.getRandomGenerator(), n, d).sample();
    }

    public double nextT(double d) throws NotStrictlyPositiveException {
        return new TDistribution(this.getRandomGenerator(), d, 1.0E-9).sample();
    }

    public double nextWeibull(double d, double d2) throws NotStrictlyPositiveException {
        return new WeibullDistribution(this.getRandomGenerator(), d, d2, 1.0E-9).sample();
    }

    public int nextZipf(int n, double d) throws NotStrictlyPositiveException {
        return new ZipfDistribution(this.getRandomGenerator(), n, d).sample();
    }

    public double nextBeta(double d, double d2) {
        return new BetaDistribution(this.getRandomGenerator(), d, d2, 1.0E-9).sample();
    }

    public int nextBinomial(int n, double d) {
        return new BinomialDistribution(this.getRandomGenerator(), n, d).sample();
    }

    public double nextCauchy(double d, double d2) {
        return new CauchyDistribution(this.getRandomGenerator(), d, d2, 1.0E-9).sample();
    }

    public double nextChiSquare(double d) {
        return new ChiSquaredDistribution(this.getRandomGenerator(), d, 1.0E-9).sample();
    }

    public double nextF(double d, double d2) throws NotStrictlyPositiveException {
        return new FDistribution(this.getRandomGenerator(), d, d2, 1.0E-9).sample();
    }

    @Override
    public double nextUniform(double d, double d2) throws NumberIsTooLargeException, NotFiniteNumberException, NotANumberException {
        return this.nextUniform(d, d2, false);
    }

    @Override
    public double nextUniform(double d, double d2, boolean bl) throws NumberIsTooLargeException, NotFiniteNumberException, NotANumberException {
        double d3;
        double d4;
        block17: {
            String string;
            block16: {
                string = BitsStreamGenerator.b();
                try {
                    if (d >= d2) {
                        throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d, d2, false);
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
                try {
                    if (Double.isInfinite(d)) {
                        throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d, new Object[0]);
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
                try {
                    if (Double.isInfinite(d2)) {
                        throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d2, new Object[0]);
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
                try {
                    try {
                        if (!Double.isNaN(d) && !Double.isNaN(d2)) break block16;
                    }
                    catch (NumberIsTooLargeException numberIsTooLargeException) {
                        throw RandomDataGenerator.b(numberIsTooLargeException);
                    }
                    throw new NotANumberException();
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
            }
            RandomGenerator randomGenerator = this.getRandomGenerator();
            double d5 = randomGenerator.nextDouble();
            while (!bl) {
                try {
                    d4 = d5;
                    d3 = 0.0;
                    if (string == null) break block17;
                    if (!(d4 <= d3)) break;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
                d5 = randomGenerator.nextDouble();
                if (string != null) continue;
            }
            d4 = d5 * d2;
            d3 = (1.0 - d5) * d;
        }
        return d4 + d3;
    }

    @Override
    public int[] nextPermutation(int n, int n2) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        try {
            if (n2 > n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)n2, n, true);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        try {
            if (n2 <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, n2);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw RandomDataGenerator.b(numberIsTooLargeException);
        }
        int[] nArray = MathArrays.natural(n);
        MathArrays.shuffle(nArray, this.getRandomGenerator());
        return MathArrays.copyOf(nArray, n2);
    }

    @Override
    public Object[] nextSample(Collection<?> collection, int n) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        Object[] objectArray;
        block10: {
            int n2 = collection.size();
            String string = BitsStreamGenerator.b();
            try {
                if (n > n2) {
                    throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)n, n2, true);
                }
            }
            catch (NumberIsTooLargeException numberIsTooLargeException) {
                throw RandomDataGenerator.b(numberIsTooLargeException);
            }
            try {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
                }
            }
            catch (NumberIsTooLargeException numberIsTooLargeException) {
                throw RandomDataGenerator.b(numberIsTooLargeException);
            }
            Object[] objectArray2 = collection.toArray();
            int[] nArray = this.nextPermutation(n2, n);
            Object[] objectArray3 = new Object[n];
            for (int i = 0; i < n; ++i) {
                try {
                    objectArray = objectArray3;
                    if (string != null) {
                        objectArray[i] = objectArray2[nArray[i]];
                        if (string != null) continue;
                        break;
                    }
                    break block10;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw RandomDataGenerator.b(numberIsTooLargeException);
                }
            }
            objectArray = objectArray3;
        }
        return objectArray;
    }

    public void reSeed(long l) {
        this.getRandomGenerator().setSeed(l);
    }

    public void reSeedSecure() {
        this.getSecRan().setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long l) {
        this.getSecRan().setSeed(l);
    }

    public void reSeed() {
        this.getRandomGenerator().setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = RandomGeneratorFactory.createRandomGenerator(SecureRandom.getInstance(string, string2));
    }

    public RandomGenerator getRandomGenerator() {
        try {
            if (this.rand == null) {
                this.initRan();
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw RandomDataGenerator.b(notStrictlyPositiveException);
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private RandomGenerator getSecRan() {
        try {
            if (this.secRand == null) {
                this.secRand = RandomGeneratorFactory.createRandomGenerator(new SecureRandom());
                this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw RandomDataGenerator.b(notStrictlyPositiveException);
        }
        return this.secRand;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    static {
        Object var0 = null;
        a = RandomDataGenerator.a(19, RandomDataGenerator.a("Y!u\u000eq"));
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x28);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 25;
                        break;
                    }
                    case 1: {
                        n5 = 122;
                        break;
                    }
                    case 2: {
                        n5 = 39;
                        break;
                    }
                    case 3: {
                        n5 = 48;
                        break;
                    }
                    case 4: {
                        n5 = 83;
                        break;
                    }
                    case 5: {
                        n5 = 1;
                        break;
                    }
                    default: {
                        n5 = 40;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

