/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.ConvergenceException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MaxCountExceededException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.Precision;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double d) throws ConvergenceException {
        return this.evaluate(d, 1.0E-8, Integer.MAX_VALUE);
    }

    public double evaluate(double d, double d2) throws ConvergenceException {
        return this.evaluate(d, d2, Integer.MAX_VALUE);
    }

    public double evaluate(double d, int n) throws ConvergenceException, MaxCountExceededException {
        return this.evaluate(d, 1.0E-8, n);
    }

    public double evaluate(double d, double d2, int n) throws ConvergenceException, MaxCountExceededException {
        int n2;
        double d3;
        block16: {
            int n3;
            double d4 = 1.0E-50;
            double d5 = this.getA(0, d);
            AdvancedEffect[] advancedEffectArray = FastMath.b();
            if (Precision.equals(d5, 0.0, 1.0E-50)) {
                d5 = 1.0E-50;
            }
            double d6 = 0.0;
            double d7 = d5;
            d3 = d5;
            for (n3 = 1; n3 < n; ++n3) {
                double d8;
                double d9;
                double d10;
                double d11;
                block17: {
                    d11 = this.getA(n3, d);
                    d10 = this.getB(n3, d);
                    d9 = d11 + d10 * d6;
                    try {
                        n2 = Precision.equals(d9, 0.0, 1.0E-50) ? 1 : 0;
                        if (advancedEffectArray == null) break block16;
                        if (n2 == 0) break block17;
                    }
                    catch (ConvergenceException convergenceException) {
                        throw ContinuedFraction.b(convergenceException);
                    }
                    d9 = 1.0E-50;
                }
                if (Precision.equals(d8 = d11 + d10 / d7, 0.0, 1.0E-50)) {
                    d8 = 1.0E-50;
                }
                d9 = 1.0 / d9;
                double d12 = d8 * d9;
                d3 = d5 * d12;
                try {
                    if (Double.isInfinite(d3)) {
                        throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_INFINITY_DIVERGENCE, d);
                    }
                }
                catch (ConvergenceException convergenceException) {
                    throw ContinuedFraction.b(convergenceException);
                }
                try {
                    if (Double.isNaN(d3)) {
                        throw new ConvergenceException(LocalizedFormats.CONTINUED_FRACTION_NAN_DIVERGENCE, d);
                    }
                }
                catch (ConvergenceException convergenceException) {
                    throw ContinuedFraction.b(convergenceException);
                }
                try {
                    if (FastMath.abs(d12 - 1.0) < d2 && advancedEffectArray != null) break;
                }
                catch (ConvergenceException convergenceException) {
                    throw ContinuedFraction.b(convergenceException);
                }
                d6 = d9;
                d7 = d8;
                d5 = d3;
                if (advancedEffectArray != null) continue;
            }
            n2 = n3;
        }
        try {
            if (n2 >= n) {
                throw new MaxCountExceededException((Localizable)LocalizedFormats.NON_CONVERGENT_CONTINUED_FRACTION, n, d);
            }
        }
        catch (ConvergenceException convergenceException) {
            throw ContinuedFraction.b(convergenceException);
        }
        return d3;
    }

    private static ConvergenceException b(ConvergenceException convergenceException) {
        return convergenceException;
    }
}

