/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.utils;

import net.advancedplugins.ae.enchanthandler.enchanttypes.utils.RollItemType;
import net.advancedplugins.ae.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.ae.utils.AManager;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemInHand {
    private final LivingEntity p;

    public ItemInHand(LivingEntity livingEntity) {
        this.p = livingEntity;
    }

    @NotNull
    public ItemStack get() {
        ItemStack itemStack;
        block5: {
            block4: {
                boolean bl = AManager.c();
                if (MinecraftVersion.getVersionNumber() >= 190) break block4;
                itemStack = this.p.getEquipment().getItemInHand();
                if (!bl) break block5;
            }
            itemStack = this.p.getEquipment().getItemInMainHand();
        }
        if (!AManager.isValid(itemStack)) {
            return new ItemStack(Material.AIR);
        }
        return itemStack;
    }

    public ItemStack getByMatching(ItemStack itemStack) {
        if (MinecraftVersion.getVersionNumber() < 190 || itemStack.isSimilar(this.p.getEquipment().getItemInHand())) {
            return this.p.getEquipment().getItemInHand();
        }
        if (itemStack.isSimilar(this.p.getEquipment().getItemInOffHand())) {
            return this.p.getEquipment().getItemInOffHand();
        }
        return null;
    }

    @NotNull
    public ItemStack getOffhand() {
        ItemStack itemStack;
        block5: {
            block4: {
                boolean bl = AManager.b();
                if (MinecraftVersion.getVersionNumber() >= 190) break block4;
                itemStack = new ItemStack(Material.AIR);
                if (bl) break block5;
            }
            itemStack = this.p.getEquipment().getItemInOffHand();
        }
        if (!AManager.isValid(itemStack)) {
            return new ItemStack(Material.AIR);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack get(RollItemType rollItemType) {
        if (rollItemType == RollItemType.HAND) {
            return this.get();
        }
        if (MinecraftVersion.getVersionNumber() >= 190 && rollItemType == RollItemType.OFFHAND) {
            return this.getOffhand();
        }
        return new ItemStack(Material.AIR);
    }

    public RollItemType getHand(ItemStack itemStack) {
        if (this.get().equals((Object)itemStack)) {
            return RollItemType.HAND;
        }
        if (MinecraftVersion.getVersionNumber() >= 190 && this.getOffhand().equals((Object)itemStack)) {
            return RollItemType.OFFHAND;
        }
        return RollItemType.HAND;
    }

    public void set(ItemStack itemStack) {
        block3: {
            block2: {
                boolean bl = AManager.b();
                if (MinecraftVersion.getVersionNumber() >= 190) break block2;
                this.p.getEquipment().setItemInHand(itemStack);
                if (bl) break block3;
            }
            this.p.getEquipment().setItemInMainHand(itemStack);
        }
    }

    public void setMeta(ItemMeta itemMeta) {
        block3: {
            block2: {
                boolean bl = AManager.c();
                if (MinecraftVersion.getVersionNumber() >= 190) break block2;
                this.p.getEquipment().getItemInHand().setItemMeta(itemMeta);
                if (!bl) break block3;
            }
            this.p.getEquipment().getItemInMainHand().setItemMeta(itemMeta);
        }
    }

    public void setOffhand(ItemStack itemStack) {
        if (MinecraftVersion.getVersionNumber() < 190) {
            return;
        }
        this.p.getEquipment().setItemInOffHand(itemStack);
    }

    public void setOffHandMeta(ItemMeta itemMeta) {
        if (MinecraftVersion.getVersionNumber() < 190) {
            return;
        }
        this.p.getEquipment().getItemInOffHand().setItemMeta(itemMeta);
    }

    public void setByMatching(ItemStack itemStack, ItemStack itemStack2) {
        if (MinecraftVersion.getVersionNumber() < 190 || itemStack.isSimilar(this.p.getEquipment().getItemInHand())) {
            this.set(itemStack2);
            return;
        }
        if (itemStack.isSimilar(this.p.getEquipment().getItemInOffHand())) {
            this.p.getEquipment().setItemInOffHand(itemStack2);
        }
    }
}

