/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.analysis.solvers;

import net.advancedplugins.ae.libs.apache.commons.math3.analysis.UnivariateFunction;
import net.advancedplugins.ae.libs.apache.commons.math3.analysis.solvers.BaseUnivariateSolver;
import net.advancedplugins.ae.libs.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MaxCountExceededException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.TooManyEvaluationsException;
import net.advancedplugins.ae.libs.apache.commons.math3.util.IntegerSequence;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAbstractUnivariateSolver<FUNC extends UnivariateFunction>
implements BaseUnivariateSolver<FUNC> {
    private static final double k = 1.0E-14;
    private static final double a = 1.0E-15;
    private final double f;
    private final double d;
    private final double i;
    private IntegerSequence.Incrementor g;
    private double j;
    private double b;
    private double c;
    private FUNC e;
    private static String[] h;

    protected BaseAbstractUnivariateSolver(double d) {
        this(1.0E-14, d, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d, double d2) {
        this(d, d2, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d, double d2, double d3) {
        this.d = d2;
        this.i = d;
        this.f = d3;
        this.g = IntegerSequence.Incrementor.create();
    }

    @Override
    public int getMaxEvaluations() {
        return this.g.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.g.getCount();
    }

    public double getMin() {
        return this.j;
    }

    public double getMax() {
        return this.b;
    }

    public double getStartValue() {
        return this.c;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.d;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.i;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.f;
    }

    protected double computeObjectiveValue(double d) {
        this.incrementEvaluationCount();
        return this.e.value(d);
    }

    protected void setup(int n, FUNC FUNC, double d, double d2, double d3) {
        MathUtils.checkNotNull(FUNC);
        this.j = d;
        this.b = d2;
        this.c = d3;
        this.e = FUNC;
        this.g = this.g.withMaximalCount(n).withStart(0);
    }

    @Override
    public double solve(int n, FUNC FUNC, double d, double d2, double d3) {
        this.setup(n, FUNC, d, d2, d3);
        return this.doSolve();
    }

    @Override
    public double solve(int n, FUNC FUNC, double d, double d2) {
        return this.solve(n, FUNC, d, d2, d + 0.5 * (d2 - d));
    }

    @Override
    public double solve(int n, FUNC FUNC, double d) {
        return this.solve(n, FUNC, Double.NaN, Double.NaN, d);
    }

    protected abstract double doSolve();

    protected boolean isBracketing(double d, double d2) {
        return UnivariateSolverUtils.isBracketing(this.e, d, d2);
    }

    protected boolean isSequence(double d, double d2, double d3) {
        return UnivariateSolverUtils.isSequence(d, d2, d3);
    }

    protected void verifyInterval(double d, double d2) {
        UnivariateSolverUtils.verifyInterval(d, d2);
    }

    protected void verifySequence(double d, double d2, double d3) {
        UnivariateSolverUtils.verifySequence(d, d2, d3);
    }

    protected void verifyBracketing(double d, double d2) {
        UnivariateSolverUtils.verifyBracketing(this.e, d, d2);
    }

    protected void incrementEvaluationCount() {
        try {
            this.g.increment();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
    }

    public static void b(String[] stringArray) {
        h = stringArray;
    }

    public static String[] b() {
        return h;
    }

    static {
        if (BaseAbstractUnivariateSolver.b() != null) {
            BaseAbstractUnivariateSolver.b(new String[4]);
        }
    }
}

