/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class CauchyDistribution
extends AbstractRealDistribution {
    public static final double h = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private final double i;
    private final double g;
    private final double f;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public CauchyDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public CauchyDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public CauchyDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d2);
        }
        this.g = d2;
        this.i = d;
        this.f = d3;
    }

    public double cumulativeProbability(double d) {
        return 0.5 + FastMath.atan((d - this.i) / this.g) / Math.PI;
    }

    public double getMedian() {
        return this.i;
    }

    public double getScale() {
        return this.g;
    }

    public double density(double d) {
        double d2 = d - this.i;
        return 0.3183098861837907 * (this.g / (d2 * d2 + this.g * this.g));
    }

    /*
     * Unable to fully structure code
     */
    public double inverseCumulativeProbability(double var1_1) {
        block9: {
            block10: {
                block8: {
                    var3_2 = AbstractRealDistribution.a();
                    try {
                        try {
                            if (!(var1_1 < 0.0) && !(var1_1 > 1.0)) break block8;
                        }
                        catch (OutOfRangeException v0) {
                            throw CauchyDistribution.b(v0);
                        }
                        throw new OutOfRangeException(var1_1, (Number)0, 1);
                    }
                    catch (OutOfRangeException v1) {
                        throw CauchyDistribution.b(v1);
                    }
                }
                if (var1_1 != 0.0) ** GOTO lbl16
                var4_3 = -Infinity;
                try {
                    if (!var3_2) break block9;
lbl16:
                    // 2 sources

                    if (var1_1 != 1.0) break block10;
                }
                catch (OutOfRangeException v2) {
                    throw CauchyDistribution.b(v2);
                }
                var4_3 = Infinity;
                if (!var3_2) break block9;
            }
            var4_3 = this.i + this.g * FastMath.tan(3.141592653589793 * (var1_1 - 0.5));
        }
        return var4_3;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.f;
    }

    public double getNumericalMean() {
        return Double.NaN;
    }

    public double getNumericalVariance() {
        return Double.NaN;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static OutOfRangeException b(OutOfRangeException outOfRangeException) {
        return outOfRangeException;
    }
}

