/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -140627372283420404L;
    private final int g;
    private final double c;
    private double f = Double.NaN;
    private boolean i = false;
    private double h = Double.NaN;
    private boolean e = false;
    private transient ZipfRejectionInversionSampler d;

    public ZipfDistribution(int n, double d) {
        this(new Well19937c(), n, d);
    }

    public ZipfDistribution(RandomGenerator randomGenerator, int n, double d) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n);
        }
        try {
            if (d <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.EXPONENT, d);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        this.g = n;
        this.c = d;
    }

    public int getNumberOfElements() {
        return this.g;
    }

    public double getExponent() {
        return this.c;
    }

    public double probability(int n) {
        block4: {
            try {
                try {
                    if (n > 0 && n <= this.g) break block4;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ZipfDistribution.b(notStrictlyPositiveException);
                }
                return 0.0;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw ZipfDistribution.b(notStrictlyPositiveException);
            }
        }
        return 1.0 / FastMath.pow((double)n, this.c) / this.generalizedHarmonic(this.g, this.c);
    }

    public double logProbability(int n) {
        block4: {
            try {
                try {
                    if (n > 0 && n <= this.g) break block4;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ZipfDistribution.b(notStrictlyPositiveException);
                }
                return Double.NEGATIVE_INFINITY;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw ZipfDistribution.b(notStrictlyPositiveException);
            }
        }
        return -FastMath.log(n) * this.c - FastMath.log(this.generalizedHarmonic(this.g, this.c));
    }

    public double cumulativeProbability(int n) {
        try {
            if (n <= 0) {
                return 0.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        try {
            if (n >= this.g) {
                return 1.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.generalizedHarmonic(n, this.c) / this.generalizedHarmonic(this.g, this.c);
    }

    public double getNumericalMean() {
        try {
            if (!this.i) {
                this.f = this.calculateNumericalMean();
                this.i = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.f;
    }

    protected double calculateNumericalMean() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 1.0);
        double d3 = this.generalizedHarmonic(n, d);
        return d2 / d3;
    }

    public double getNumericalVariance() {
        try {
            if (!this.e) {
                this.h = this.calculateNumericalVariance();
                this.e = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.h;
    }

    protected double calculateNumericalVariance() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 2.0);
        double d3 = this.generalizedHarmonic(n, d - 1.0);
        double d4 = this.generalizedHarmonic(n, d);
        return d2 / d4 - d3 * d3 / (d4 * d4);
    }

    private double generalizedHarmonic(int n, double d) {
        double d2;
        block2: {
            double d3 = 0.0;
            boolean bl = AbstractRealDistribution.b();
            for (int i = n; i > 0; --i) {
                d2 = d3 + 1.0 / FastMath.pow((double)i, d);
                if (bl) {
                    d3 = d2;
                    if (bl) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    public int getSupportLowerBound() {
        return 1;
    }

    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        try {
            if (this.d == null) {
                this.d = new ZipfRejectionInversionSampler(this.g, this.c);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.d.sample(this.b);
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }

    static final class ZipfRejectionInversionSampler {
        private final double c;
        private final int e;
        private final double d;
        private final double b;
        private final double a;

        ZipfRejectionInversionSampler(int n, double d) {
            this.c = d;
            this.e = n;
            this.d = this.hIntegral(1.5) - 1.0;
            this.b = this.hIntegral((double)n + 0.5);
            this.a = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
        }

        int sample(RandomGenerator randomGenerator) {
            double d;
            double d2;
            int n;
            boolean bl = AbstractRealDistribution.b();
            do {
                if ((n = (int)((d2 = this.hIntegralInverse(d = this.b + randomGenerator.nextDouble() * (this.d - this.b))) + 0.5)) < 1) {
                    n = 1;
                    if (!bl || bl) continue;
                }
                if (n <= this.e) continue;
                n = this.e;
            } while (!((double)n - d2 <= this.a) && !(d >= this.hIntegral((double)n + 0.5) - this.h(n)));
            return n;
        }

        private double hIntegral(double d) {
            double d2 = FastMath.log(d);
            return ZipfRejectionInversionSampler.helper2((1.0 - this.c) * d2) * d2;
        }

        private double h(double d) {
            return FastMath.exp(-this.c * FastMath.log(d));
        }

        private double hIntegralInverse(double d) {
            double d2 = d * (1.0 - this.c);
            if (d2 < -1.0) {
                d2 = -1.0;
            }
            return FastMath.exp(ZipfRejectionInversionSampler.helper1(d2) * d);
        }

        static double helper1(double d) {
            if (FastMath.abs(d) > 1.0E-8) {
                return FastMath.log1p(d) / d;
            }
            return 1.0 - d * (0.5 - d * (0.3333333333333333 - d * 0.25));
        }

        static double helper2(double d) {
            if (FastMath.abs(d) > 1.0E-8) {
                return FastMath.expm1(d) / d;
            }
            return 1.0 + d * 0.5 * (1.0 + d * 0.3333333333333333 * (1.0 + d * 0.25));
        }
    }
}

