/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_16_R3;

import de.jeff_media.angelchest.jefflib.ai.goal.CustomGoal;
import de.jeff_media.angelchest.jefflib.ai.goal.CustomGoalExecutor;
import de.jeff_media.angelchest.jefflib.ai.goal.PathfinderGoal;
import de.jeff_media.angelchest.thirdparty.org.jetbrains.annotations.NotNull;
import de.jeff_media.angelchest.thirdparty.org.jetbrains.annotations.Nullable;
import java.util.stream.Stream;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DedicatedServer;
import net.minecraft.server.v1_16_R3.EntityCreature;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IMaterial;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.RecipeItemStack;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public final class NMS {
    public static WorldServer getLevel(World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static BlockPosition getBlockPos(org.bukkit.block.Block block) {
        return ((CraftBlock)block).getPosition();
    }

    public static net.minecraft.server.v1_16_R3.Entity toNms(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public static Entity toBukkit(net.minecraft.server.v1_16_R3.Entity entity) {
        return entity.getBukkitEntity();
    }

    public static EntityLiving toNms(LivingEntity livingEntity) {
        return ((CraftLivingEntity)livingEntity).getHandle();
    }

    public static LivingEntity toBukkit(EntityLiving entityLiving) {
        return (LivingEntity)entityLiving.getBukkitEntity();
    }

    public static RecipeItemStack ingredient(Stream<Material> stream) {
        return RecipeItemStack.a(stream.map(material -> new ItemStack((IMaterial)CraftMagicNumbers.getItem((Material)material))));
    }

    @NotNull
    public static EntityCreature asPathfinder(Creature creature) {
        return ((CraftCreature)creature).getHandle();
    }

    @NotNull
    public static EntityInsentient asMob(Mob mob) {
        return ((CraftMob)mob).getHandle();
    }

    public static DedicatedServer getDedicatedServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public static BlockPosition toNms(BlockVector blockVector) {
        return new BlockPosition(blockVector.getX(), blockVector.getY(), blockVector.getZ());
    }

    public static BlockVector toBukkit(@Nullable BlockPosition blockPosition) {
        if (blockPosition == null) {
            return null;
        }
        return new BlockVector(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
    }

    public static Vec3D toNms(Vector vector) {
        return new Vec3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector toBukkit(Vec3D vec3D) {
        return new Vector(vec3D.x, vec3D.y, vec3D.z);
    }

    public static net.minecraft.server.v1_16_R3.PathfinderGoal toNms(PathfinderGoal pathfinderGoal) {
        CustomGoalExecutor customGoalExecutor;
        if (pathfinderGoal instanceof net.minecraft.server.v1_16_R3.PathfinderGoal) {
            return (net.minecraft.server.v1_16_R3.PathfinderGoal)pathfinderGoal;
        }
        if (pathfinderGoal instanceof CustomGoal && (customGoalExecutor = ((CustomGoal)pathfinderGoal).getExecutor()) instanceof net.minecraft.server.v1_16_R3.PathfinderGoal) {
            return (net.minecraft.server.v1_16_R3.PathfinderGoal)customGoalExecutor;
        }
        throw new IllegalArgumentException("Not a valid Goal: " + pathfinderGoal.getClass().getName() + ". For custom goals, extend " + CustomGoal.class.getName());
    }

    public static MinecraftServer getServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public static EntityPlayer toNms(Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    public static Block toNms(org.bukkit.block.Block block) {
        return ((CraftBlock)block).getNMS().getBlock();
    }
}

