/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_18_R1;

import de.jeff_media.angelchest.jefflib.data.tuples.Pair;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;

final class NMSBiomeUtils {
    private static final ResourceKey<IRegistry<BiomeBase>> BIOME_REGISTRY_RESOURCE_KEY = IRegistry.aR;

    static Pair<String, String> getBiomeName(Location location) {
        MinecraftKey minecraftKey = NMSBiomeUtils.getBiomeKey(location);
        return new Pair((Object)minecraftKey.b(), (Object)minecraftKey.a());
    }

    static MinecraftKey getBiomeKey(Location location) {
        IRegistry<BiomeBase> iRegistry = NMSBiomeUtils.getBiomeRegistry();
        return iRegistry.b((Object)NMSBiomeUtils.getBiomeBase(location));
    }

    static IRegistry<BiomeBase> getBiomeRegistry() {
        DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
        return (IRegistry)dedicatedServer.aV().c(BIOME_REGISTRY_RESOURCE_KEY).get();
    }

    static BiomeBase getBiomeBase(Location location) {
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Chunk chunk = ((CraftWorld)location.getWorld()).getHandle().l(blockPosition);
        if (chunk != null) {
            return chunk.getNoiseBiome(blockPosition.u(), blockPosition.v(), blockPosition.w());
        }
        return null;
    }

    private NMSBiomeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

