/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.model.Model;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class Animation {
    public static final NamespacedKey KEY = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), "inAnimation");
    private final Player player;
    private Consumer<Animation> callback;
    private final AtomicReference<Reward> reward;
    private final AnimationManager animationManager;
    private boolean started;

    public Animation(AnimationManager animationManager, Player player, AtomicReference<Reward> atomicReference, Consumer<Animation> consumer) {
        this.animationManager = animationManager;
        this.player = player;
        this.callback = consumer;
        this.reward = atomicReference;
        this.started = false;
        this.getAnimationManager().addAnimation(this.getPlayer(), this);
    }

    public abstract void begin();

    public abstract void start();

    public void reroll() {
        this.getCallback().accept(this);
    }

    public abstract void end();

    public Player getPlayer() {
        return this.player;
    }

    public Consumer<Animation> getCallback() {
        return this.callback;
    }

    public void setCallback(Consumer<Animation> consumer) {
        this.callback = consumer;
    }

    public AtomicReference<Reward> getReward() {
        return this.reward;
    }

    public abstract void spawnReward(int var1, int var2, int var3, Vector var4, boolean var5, Vector var6);

    public abstract Model getModel();

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean bl) {
        this.started = bl;
    }
}

