/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation.impl;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.animation.RewardItem;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.model.Model;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlacedCratePersonalisedAnimation
extends Animation {
    private final Model model;
    private final PlacedCrate placedCrate;
    private int i;
    private BukkitRunnable runnable;
    private RewardItem rewardItem = null;

    public PlacedCratePersonalisedAnimation(AnimationManager animationManager, Player player, AtomicReference<Reward> atomicReference, Consumer<Animation> consumer, PlacedCrate placedCrate) {
        super(animationManager, player, atomicReference, consumer);
        this.placedCrate = placedCrate;
        if (placedCrate == null) {
            this.model = null;
            this.reroll();
        } else {
            placedCrate.getModel().hide(player);
            this.model = Model.create(placedCrate.getCrate().getModel(), placedCrate.getLocation(), player);
            this.begin();
        }
    }

    @Override
    public void begin() {
        this.getPlayer().getPersistentDataContainer().set(KEY, PersistentDataType.INTEGER, (Object)1);
        this.start();
    }

    @Override
    public void start() {
        this.setStarted(true);
        this.getAnimationManager().showTitle(this.getAnimationManager().getOpeningTitle(), this.getPlayer());
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        if (this.model == null) {
            this.reroll();
            return;
        }
        this.model.playAnimation("open");
        this.i = 0;
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.runnable = new BukkitRunnable(){

            public void run() {
                PlacedCratePersonalisedAnimation.this.getAnimationManager().playTask(PlacedCratePersonalisedAnimation.this.i, PlacedCratePersonalisedAnimation.this);
                if (PlacedCratePersonalisedAnimation.this.getAnimationManager().shouldStopAnimation(PlacedCratePersonalisedAnimation.this.i)) {
                    PlacedCratePersonalisedAnimation.this.reroll();
                }
                ++PlacedCratePersonalisedAnimation.this.i;
            }
        };
        this.runnable.runTaskTimer((Plugin)AquaticCratesTesting.instance(), 0L, 1L);
    }

    @Override
    public void reroll() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        super.reroll();
    }

    @Override
    public void end() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        if (this.model != null) {
            this.model.remove();
        }
        if (this.placedCrate != null) {
            this.placedCrate.getModel().show(this.getPlayer());
        }
        this.getPlayer().getPersistentDataContainer().remove(KEY);
    }

    @Override
    public void spawnReward(int n, int n2, int n3, Vector vector, boolean bl, Vector vector2) {
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
        }
        this.rewardItem = new RewardItem(this.getPlayer(), this, n, n2, n3, vector, bl, vector2);
        this.rewardItem.spawn();
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

