/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.camera;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.camera.CameraMovement;
import cz.larkyy.aquaticcratestesting.nms.NMSHandler;
import java.util.Arrays;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Camera {
    private int id;
    private final Player player;
    private Location prevLocation;
    private GameMode prevMode;
    private CameraMovement cameraMovement;

    public Camera(Location location, Player player) {
        this.player = player;
        this.id = this.spawnEntity(location.clone().add(0.0, 1.8, 0.0));
    }

    private int spawnEntity(Location location) {
        return AquaticCratesTesting.getNmsHandler().spawnEntity(location, entity -> {
            ArmorStand armorStand = (ArmorStand)entity;
            armorStand.setInvisible(true);
            armorStand.setMarker(true);
            armorStand.setPersistent(false);
        }, Arrays.asList(this.player), "armor_stand");
    }

    public Location location() {
        return this.nmsHandler().getEntity(this.id).getLocation();
    }

    public void teleport(Location location) {
        if (this.cameraMovement != null) {
            this.cameraMovement.stop();
        }
        this.nmsHandler().teleportEntity(this.id, location);
    }

    public void move(Location location) {
        this.nmsHandler().moveEntity(this.id, location);
    }

    public void setMovement(Vector vector, int n, float f, float f2) {
        if (this.cameraMovement != null) {
            this.cameraMovement.stop();
        }
        Location location = this.location().clone().add(vector);
        location.setYaw(location.getYaw() + f);
        location.setPitch(location.getPitch() + f2);
        this.cameraMovement = new CameraMovement(this, location, n);
        this.cameraMovement.start();
    }

    public void attachPlayer(final Runnable runnable) {
        this.prevLocation = this.player.getPlayer().getLocation();
        this.prevMode = this.player.getGameMode();
        int n = 0;
        if (!this.player.getLocation().getWorld().equals(this.location().getWorld())) {
            n = 5;
        }
        this.player.teleport(this.location().clone().add(0.0, 2.0, 0.0));
        new BukkitRunnable(){

            public void run() {
                Camera.this.id = Camera.this.spawnEntity(Camera.this.location());
                Camera.this.player.setGameMode(GameMode.SPECTATOR);
                Camera.this.nmsHandler().setPlayerInfo("UPDATE_GAME_MODE", Camera.this.player.getPlayer(), "CREATIVE");
                Camera.this.nmsHandler().changeGamemode(Camera.this.player, GameMode.SPECTATOR);
                Camera.this.nmsHandler().setCamera(Camera.this.id, Camera.this.player);
                runnable.run();
            }
        }.runTaskLater((Plugin)AquaticCratesTesting.instance(), (long)n);
    }

    public void detachPlayer() {
        this.nmsHandler().setCamera(0, this.player);
        this.nmsHandler().changeGamemode(this.player, this.prevMode);
        this.player.setGameMode(this.prevMode);
        this.player.teleport(this.prevLocation);
    }

    public void despawn() {
        if (this.cameraMovement != null) {
            this.cameraMovement.stop();
        }
        this.detachPlayer();
        new BukkitRunnable(){

            public void run() {
                Camera.this.nmsHandler().despawnEntity(Arrays.asList(Camera.this.id), Arrays.asList(Camera.this.player));
            }
        }.runTaskLaterAsynchronously((Plugin)AquaticCratesTesting.instance(), 1L);
    }

    private NMSHandler nmsHandler() {
        return AquaticCratesTesting.getNmsHandler();
    }
}

