/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.camera;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.camera.Camera;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CameraMovement {
    private final Location previousLocation;
    private final Location destinationLocation;
    private final int duration;
    private final Camera camera;
    private BukkitRunnable runnable;
    private final float yawOffset;
    private final float pitchOffset;
    private final Vector offset;
    private int i = 0;

    public CameraMovement(Camera camera, Location location, int n) {
        this.camera = camera;
        this.destinationLocation = location.clone();
        this.duration = n;
        this.previousLocation = camera.location().clone();
        this.offset = location.toVector().subtract(this.previousLocation.toVector());
        this.offset.multiply(1.0 / (double)n);
        this.yawOffset = (location.getYaw() - this.previousLocation.getYaw()) / (float)n;
        this.pitchOffset = (location.getPitch() - this.previousLocation.getPitch()) / (float)n;
    }

    public Location getLocation(int n) {
        Vector vector = this.offset.clone();
        vector.multiply(n);
        Location location = this.previousLocation.clone().add(vector);
        float f = this.yawOffset;
        float f2 = this.pitchOffset;
        location.setYaw(this.previousLocation.getYaw() + (f *= (float)n));
        location.setPitch(this.previousLocation.getPitch() + (f2 *= (float)n));
        return location;
    }

    public void move(int n) {
        Location location = this.getLocation(n);
        this.camera.move(location);
    }

    public void start() {
        this.runnable = new BukkitRunnable(){

            public void run() {
                if (CameraMovement.this.i > CameraMovement.this.duration) {
                    this.cancel();
                }
                CameraMovement.this.move(CameraMovement.this.i);
                ++CameraMovement.this.i;
            }
        };
        this.runnable.runTaskTimerAsynchronously((Plugin)AquaticCratesTesting.getPlugin(AquaticCratesTesting.class), 0L, 1L);
    }

    public void stop() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
    }
}

