/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.shaded.itemlibrary.CustomItem;
import java.util.HashMap;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Key {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)AquaticCratesTesting.getPlugin(AquaticCratesTesting.class), "KeyIdentifier");
    private final CustomItem item;
    private final Crate crate;
    private final boolean requiresCrateToOpen;

    public Key(CustomItem customItem, Crate crate, boolean bl) {
        this.item = customItem;
        this.crate = crate;
        this.requiresCrateToOpen = bl;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public String getIdentifier() {
        return this.crate.getIdentifier();
    }

    public String getDisplayName() {
        return this.crate.getDisplayName();
    }

    public void give(List<Player> list, int n) {
        ItemStack itemStack = this.item.getItem();
        itemStack.setAmount(n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)this.crate.getIdentifier());
        itemStack.setItemMeta(itemMeta);
        list.forEach(player -> {
            HashMap hashMap = player.getInventory().addItem(new ItemStack[]{itemStack});
            hashMap.forEach((n, itemStack) -> player.getLocation().getWorld().dropItem(player.getLocation(), itemStack));
        });
    }

    public boolean isItemKey(ItemStack itemStack) {
        Key key = Key.get(itemStack);
        if (key == null) {
            return false;
        }
        return key.getIdentifier().equals(this.getIdentifier());
    }

    public static Key get(String string) {
        return AquaticCratesAPI.getKey(string);
    }

    public static Key get(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        String string = (String)itemMeta.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        return Key.get(string);
    }

    public boolean requiresCrateToOpen() {
        return this.requiresCrateToOpen;
    }
}

