/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.hologram.Hologram;
import cz.larkyy.aquaticcratestesting.hologram.impl.AquaticHologram;
import cz.larkyy.aquaticcratestesting.model.Model;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PlacedCrate {
    private final Location location;
    private final Crate crate;
    private final Model model;
    private final Hologram hologram;

    public PlacedCrate(Crate crate, Location location, String string) {
        this.location = location;
        this.crate = crate;
        this.hologram = new AquaticHologram(location.clone().add(0.0, crate.getHologramYOffset(), 0.0), crate.getHologram());
        this.hologram.spawn(new ArrayList<Player>(Bukkit.getOnlinePlayers()), list -> {});
        this.model = Model.create(string, location, null);
        location.getBlock().setType(Material.BARRIER);
    }

    public static PlacedCrate get(Location location) {
        if (location == null) {
            return null;
        }
        return AquaticCratesAPI.getCrateHandler().getPlacedCrate(location);
    }

    public Location getLocation() {
        return this.location;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public Model getModel() {
        return this.model;
    }

    public void destroy() {
        this.model.remove();
        this.location.getBlock().setType(Material.AIR);
        this.hologram.despawn();
    }

    public boolean open(CratePlayer cratePlayer, boolean bl) {
        return this.crate.open(cratePlayer, this, bl);
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

