/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate.inventories;

import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import cz.larkyy.aquaticcratestesting.shaded.menulib.Menu;
import cz.larkyy.aquaticcratestesting.shaded.menulib.MenuItem;
import cz.larkyy.aquaticcratestesting.utils.colors.Colors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PreviewGUI {
    private final Crate crate;
    private final List<Integer> rewardSlots;
    private final Menu.Builder mb;
    private final List<String> rewardLore;
    private final boolean openableByKey;

    public PreviewGUI(Crate crate, Menu.Builder builder, List<Integer> list, List<String> list2, boolean bl) {
        this.crate = crate;
        this.rewardSlots = list;
        this.mb = builder;
        this.openableByKey = bl;
        this.rewardLore = list2;
    }

    public void open(Player player, int n, PlacedCrate placedCrate) {
        Menu.Builder builder = this.mb.clone();
        this.loadRewardItems(player, builder, n);
        Menu menu = builder.build();
        MenuItem menuItem = menu.getItem("next-page");
        if (menuItem != null) {
            menuItem.addAction(inventoryClickEvent -> this.openNextPage(player, n, placedCrate));
        }
        if ((menuItem = menu.getItem("prev-page")) != null) {
            menuItem.addAction(inventoryClickEvent -> this.openPrevPage(player, n, placedCrate));
        }
        if ((menuItem = menu.getItem("open-button")) != null) {
            menuItem.addAction(inventoryClickEvent -> {
                player.closeInventory();
                this.crate.open(CratePlayer.get(player), placedCrate, false);
            });
        }
        if ((menuItem = menu.getItem("close-button")) != null) {
            menuItem.addAction(inventoryClickEvent -> player.closeInventory());
        }
        for (ItemStack itemStack : menu.getInventory().getContents()) {
            if (itemStack == null || itemStack.getItemMeta() == null || itemStack.getItemMeta().getLore() == null) continue;
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setLore(PlaceholderAPI.setPlaceholders((Player)player.getPlayer(), (List)itemMeta.getLore()));
            itemStack.setItemMeta(itemMeta);
        }
        player.openInventory(menu.getInventory());
    }

    public void openNextPage(Player player, int n, PlacedCrate placedCrate) {
        if (this.hasNextPage(player, n)) {
            this.open(player, n + 1, placedCrate);
        }
    }

    private boolean hasNextPage(Player player, int n) {
        List<Reward> list = this.crate.getPossibleRewards(player);
        return n < list.size() / this.rewardSlots.size();
    }

    public void openPrevPage(Player player, int n, PlacedCrate placedCrate) {
        if (this.hasPreviousPage(n)) {
            this.open(player, n - 1, placedCrate);
        }
    }

    private boolean hasPreviousPage(int n) {
        return n > 0;
    }

    public boolean isOpenableByKey() {
        return this.openableByKey;
    }

    public void loadRewardItems(Player player, Menu.Builder builder, int n) {
        List<Reward> list = this.crate.getPossibleRewards(player);
        int n2 = n * this.rewardSlots.size();
        for (int n3 : this.rewardSlots) {
            if (n2 >= list.size()) {
                return;
            }
            Reward reward = list.get(n2);
            ItemStack itemStack = reward.getPreviewItem().getItem();
            ItemMeta itemMeta = itemStack.getItemMeta();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (itemMeta.getLore() != null) {
                arrayList.addAll(itemMeta.getLore());
            }
            arrayList.addAll(Colors.format(this.rewardLore));
            arrayList.replaceAll(string -> string.replace("%chance%", "" + reward.getChance()));
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
            builder.addItem(MenuItem.builder("reward-" + reward.getIdentifier(), itemStack).slots(Arrays.asList(n3)).action(inventoryClickEvent -> {
                HumanEntity humanEntity = inventoryClickEvent.getWhoClicked();
                if (!(humanEntity instanceof Player)) {
                    return;
                }
                Player player = (Player)humanEntity;
                if (player.hasPermission("aquaticcrates.admin")) {
                    reward.give(player);
                }
            }).build());
            ++n2;
        }
    }
}

