/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate.reroll;

import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.reroll.RerollManager;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class Reroll {
    private final Player player;
    private final Crate crate;
    private boolean rerolling;
    private final RerollManager rerollManager;
    private int reroll;
    private AtomicReference<Reward> reward;
    private final Consumer<Reward> claimConsumer;
    private final Consumer<Reward> rerollConsumer;

    public Reroll(RerollManager rerollManager, Player player, AtomicReference<Reward> atomicReference, Consumer<Reward> consumer, Consumer<Reward> consumer2) {
        this.player = player;
        this.crate = rerollManager.getCrate();
        this.reroll = 0;
        this.reward = atomicReference;
        this.rerollManager = rerollManager;
        this.rerolling = false;
        this.claimConsumer = consumer;
        this.rerollConsumer = consumer2;
    }

    public abstract void activate(Event var1);

    public abstract void open();

    public void reroll() {
        ++this.reroll;
        this.rerolling = false;
        this.reward.set(this.crate.getRandomReward(this.player));
        this.rerollConsumer.accept(this.reward.get());
    }

    public void claim() {
        this.rerolling = false;
        this.claimConsumer.accept(this.reward.get());
    }

    public int getReroll() {
        return this.reroll;
    }

    public boolean isRerolling() {
        return this.rerolling;
    }

    public void setRerolling(boolean bl) {
        this.rerolling = bl;
    }

    public Player getPlayer() {
        return this.player;
    }

    public RerollManager getRerollManager() {
        return this.rerollManager;
    }

    public Reward getReward() {
        return this.reward.get();
    }

    public static Reroll get(Player player) {
        return AquaticCratesAPI.getPlayerHandler().getRerollPlayer(player);
    }
}

