/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.hibernate;

import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;
import me.coley.recaf.metadata.InsnComment;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";
    public static final String CONFIG_PREFIX_DATASOURCE = "hibernate.hikari.dataSource.";

    @InsnComment(At_0="c3bV9GWrNUaYpUThV0c0U3UrFTYxUEVNRTUU1UNjRlTwcmbhZUe3x0dqVnVldHWKRWcP1WO")
    public static HikariConfig loadConfiguration(Map map) {
        Properties properties = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.isolation", map, "transactionIsolation", properties);
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", map, "autoCommit", properties);
        HikariConfigurationUtil.copyProperty("hibernate.connection.driver_class", map, "driverClassName", properties);
        HikariConfigurationUtil.copyProperty("hibernate.connection.url", map, "jdbcUrl", properties);
        HikariConfigurationUtil.copyProperty("hibernate.connection.username", map, "username", properties);
        HikariConfigurationUtil.copyProperty("hibernate.connection.password", map, "password", properties);
        for (Object k : map.keySet()) {
            String string = (String)k;
            if (!string.startsWith(CONFIG_PREFIX)) continue;
            properties.setProperty(string.substring(CONFIG_PREFIX.length()), (String)map.get(string));
        }
        return new HikariConfig(properties);
    }

    private static void copyProperty(String string, Map map, String string2, Properties properties) {
        if (map.containsKey(string)) {
            properties.setProperty(string2, (String)map.get(string));
        }
    }
}

