/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.SQLExceptionOverride;
import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.PoolEntry;
import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.util.ClockSource;
import com.zaxxer.hikari.util.DriverDataSource;
import com.zaxxer.hikari.util.PropertyElf;
import com.zaxxer.hikari.util.UtilityElf;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PoolBase {
    private final Logger logger = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate metricsTracker;
    protected final String poolName;
    volatile String catalog;
    final AtomicReference<Exception> lastConnectionFailure;
    long connectionTimeout;
    long validationTimeout;
    SQLExceptionOverride exceptionOverride;
    private static final String[] RESET_STATES = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int UNINITIALIZED = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private int networkTimeout;
    private int isNetworkTimeoutSupported;
    private int isQueryTimeoutSupported;
    private int defaultTransactionIsolation;
    private int transactionIsolation;
    private Executor netTimeoutExecutor;
    private DataSource dataSource;
    private final String schema;
    private final boolean isReadOnly;
    private final boolean isAutoCommit;
    private final boolean isUseJdbc4Validation;
    private final boolean isIsolateInternalQueries;
    private volatile boolean isValidChecked;

    PoolBase(HikariConfig hikariConfig) {
        this.config = hikariConfig;
        this.networkTimeout = -1;
        this.catalog = hikariConfig.getCatalog();
        this.schema = hikariConfig.getSchema();
        this.isReadOnly = hikariConfig.isReadOnly();
        this.isAutoCommit = hikariConfig.isAutoCommit();
        this.exceptionOverride = UtilityElf.createInstance(hikariConfig.getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.transactionIsolation = UtilityElf.getTransactionIsolation(hikariConfig.getTransactionIsolation());
        this.isQueryTimeoutSupported = -1;
        this.isNetworkTimeoutSupported = -1;
        this.isUseJdbc4Validation = hikariConfig.getConnectionTestQuery() == null;
        this.isIsolateInternalQueries = hikariConfig.isIsolateInternalQueries();
        this.poolName = hikariConfig.getPoolName();
        this.connectionTimeout = hikariConfig.getConnectionTimeout();
        this.validationTimeout = hikariConfig.getValidationTimeout();
        this.lastConnectionFailure = new AtomicReference();
        this.initializeDataSource();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void recycle(PoolEntry var1);

    void quietlyCloseConnection(Connection connection, String string) {
        if (connection != null) {
            try {
                this.logger.debug("{} - Closing connection {}: {}", this.poolName, connection, string);
                try (Connection connection2 = connection;){
                    this.setNetworkTimeout(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                this.logger.debug("{} - Closing connection {} failed", this.poolName, connection, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isConnectionDead(Connection connection) {
        try {
            try {
                this.setNetworkTimeout(connection, this.validationTimeout);
                int n = (int)Math.max(1000L, this.validationTimeout) / 1000;
                if (this.isUseJdbc4Validation) {
                    boolean bl = !connection.isValid(n);
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    if (this.isNetworkTimeoutSupported != 1) {
                        this.setQueryTimeout(statement, n);
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return false;
                }
            }
            finally {
                this.setNetworkTimeout(connection, this.networkTimeout);
                if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.lastConnectionFailure.set(exception);
            this.logger.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", this.poolName, connection, exception.getMessage());
            return true;
        }
    }

    Exception getLastConnectionFailure() {
        return this.lastConnectionFailure.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.dataSource;
    }

    PoolEntry newPoolEntry() {
        return new PoolEntry(this.newConnection(), this, this.isReadOnly, this.isAutoCommit);
    }

    void resetConnectionState(Connection connection, ProxyConnection proxyConnection, int n) {
        int n2 = 0;
        if ((n & 1) != 0 && proxyConnection.getReadOnlyState() != this.isReadOnly) {
            connection.setReadOnly(this.isReadOnly);
            n2 |= 1;
        }
        if ((n & 2) != 0 && proxyConnection.getAutoCommitState() != this.isAutoCommit) {
            connection.setAutoCommit(this.isAutoCommit);
            n2 |= 2;
        }
        if ((n & 4) != 0 && proxyConnection.getTransactionIsolationState() != this.transactionIsolation) {
            connection.setTransactionIsolation(this.transactionIsolation);
            n2 |= 4;
        }
        if ((n & 8) != 0 && this.catalog != null && !this.catalog.equals(proxyConnection.getCatalogState())) {
            connection.setCatalog(this.catalog);
            n2 |= 8;
        }
        if ((n & 0x10) != 0 && proxyConnection.getNetworkTimeoutState() != this.networkTimeout) {
            this.setNetworkTimeout(connection, this.networkTimeout);
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0 && this.schema != null && !this.schema.equals(proxyConnection.getSchemaState())) {
            connection.setSchema(this.schema);
            n2 |= 0x20;
        }
        if (n2 != 0 && this.logger.isDebugEnabled()) {
            this.logger.debug("{} - Reset ({}) on connection {}", this.poolName, this.stringFromResetBits(n2), connection);
        }
    }

    void shutdownNetworkTimeoutExecutor() {
        if (this.netTimeoutExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.netTimeoutExecutor).shutdownNow();
        }
    }

    long getLoginTimeout() {
        try {
            return this.dataSource != null ? (long)this.dataSource.getLoginTimeout() : TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void handleMBeans(HikariPool hikariPool, boolean bl) {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            ObjectName objectName;
            ObjectName objectName2;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                objectName2 = new ObjectName("com.zaxxer.hikari:type=PoolConfig,name=" + this.poolName);
                objectName = new ObjectName("com.zaxxer.hikari:type=Pool,name=" + this.poolName);
            } else {
                objectName2 = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + this.poolName + ")");
                objectName = new ObjectName("com.zaxxer.hikari:type=Pool (" + this.poolName + ")");
            }
            if (bl) {
                if (!mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.registerMBean(this.config, objectName2);
                    mBeanServer.registerMBean(hikariPool, objectName);
                } else {
                    this.logger.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                }
            } else if (mBeanServer.isRegistered(objectName2)) {
                mBeanServer.unregisterMBean(objectName2);
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            this.logger.warn("{} - Failed to {} management beans.", this.poolName, bl ? "register" : "unregister", exception);
        }
    }

    private void initializeDataSource() {
        String string = this.config.getJdbcUrl();
        String string2 = this.config.getUsername();
        String string3 = this.config.getPassword();
        String string4 = this.config.getDataSourceClassName();
        String string5 = this.config.getDriverClassName();
        String string6 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string4 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string4, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string5, properties, string2, string3);
        } else if (string6 != null && dataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(string6);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.setLoginTimeout(dataSource);
            this.createNetworkTimeoutExecutor(dataSource, string4, string);
        }
        this.dataSource = dataSource;
    }

    private Connection newConnection() {
        long l = ClockSource.currentTime();
        Connection connection = null;
        try {
            String string = this.config.getUsername();
            String string2 = this.config.getPassword();
            Connection connection2 = connection = string == null ? this.dataSource.getConnection() : this.dataSource.getConnection(string, string2);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            this.setupConnection(connection);
            this.lastConnectionFailure.set(null);
            Connection connection3 = connection;
            return connection3;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.quietlyCloseConnection(connection, "(Failed to create/setup connection)");
            } else if (this.getLastConnectionFailure() == null) {
                this.logger.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.lastConnectionFailure.set(exception);
            throw exception;
        }
        finally {
            if (this.metricsTracker != null) {
                this.metricsTracker.recordConnectionCreated(ClockSource.elapsedMillis(l));
            }
        }
    }

    private void setupConnection(Connection connection) {
        try {
            if (this.networkTimeout == -1) {
                this.networkTimeout = this.getAndSetNetworkTimeout(connection, this.validationTimeout);
            } else {
                this.setNetworkTimeout(connection, this.validationTimeout);
            }
            if (connection.isReadOnly() != this.isReadOnly) {
                connection.setReadOnly(this.isReadOnly);
            }
            if (connection.getAutoCommit() != this.isAutoCommit) {
                connection.setAutoCommit(this.isAutoCommit);
            }
            this.checkDriverSupport(connection);
            if (this.transactionIsolation != this.defaultTransactionIsolation) {
                connection.setTransactionIsolation(this.transactionIsolation);
            }
            if (this.catalog != null) {
                connection.setCatalog(this.catalog);
            }
            if (this.schema != null) {
                connection.setSchema(this.schema);
            }
            this.executeSql(connection, this.config.getConnectionInitSql(), true);
            this.setNetworkTimeout(connection, this.networkTimeout);
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void checkDriverSupport(Connection connection) {
        if (!this.isValidChecked) {
            this.checkValidationSupport(connection);
            this.checkDefaultIsolation(connection);
            this.isValidChecked = true;
        }
    }

    private void checkValidationSupport(Connection connection) {
        try {
            if (this.isUseJdbc4Validation) {
                connection.isValid(1);
            } else {
                this.executeSql(connection, this.config.getConnectionTestQuery(), false);
            }
        }
        catch (AbstractMethodError | Exception throwable) {
            this.logger.error("{} - Failed to execute{} connection test query ({}).", this.poolName, this.isUseJdbc4Validation ? " isValid() for connection, configure" : "", throwable.getMessage());
            throw throwable;
        }
    }

    private void checkDefaultIsolation(Connection connection) {
        block3: {
            try {
                this.defaultTransactionIsolation = connection.getTransactionIsolation();
                if (this.transactionIsolation == -1) {
                    this.transactionIsolation = this.defaultTransactionIsolation;
                }
            }
            catch (SQLException sQLException) {
                this.logger.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
                if (sQLException.getSQLState() == null || sQLException.getSQLState().startsWith("08")) break block3;
                throw sQLException;
            }
        }
    }

    private void setQueryTimeout(Statement statement, int n) {
        block3: {
            if (this.isQueryTimeoutSupported != 0) {
                try {
                    statement.setQueryTimeout(n);
                    this.isQueryTimeoutSupported = 1;
                }
                catch (Exception exception) {
                    if (this.isQueryTimeoutSupported != -1) break block3;
                    this.isQueryTimeoutSupported = 0;
                    this.logger.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int getAndSetNetworkTimeout(Connection connection, long l) {
        block4: {
            if (this.isNetworkTimeoutSupported != 0) {
                try {
                    int n = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.netTimeoutExecutor, (int)l);
                    this.isNetworkTimeoutSupported = 1;
                    return n;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.isNetworkTimeoutSupported != -1) break block4;
                    this.isNetworkTimeoutSupported = 0;
                    this.logger.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.validationTimeout < TimeUnit.SECONDS.toMillis(1L)) {
                        this.logger.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.validationTimeout % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.logger.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void setNetworkTimeout(Connection connection, long l) {
        if (this.isNetworkTimeoutSupported == 1) {
            connection.setNetworkTimeout(this.netTimeoutExecutor, (int)l);
        }
    }

    private void executeSql(Connection connection, String string, boolean bl) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                if (bl) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
            }
        }
    }

    private void createNetworkTimeoutExecutor(DataSource dataSource, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.netTimeoutExecutor = new SynchronousExecutor();
        } else {
            ThreadFactory threadFactory = this.config.getThreadFactory();
            threadFactory = threadFactory != null ? threadFactory : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            threadPoolExecutor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.netTimeoutExecutor = threadPoolExecutor;
        }
    }

    private void setLoginTimeout(DataSource dataSource) {
        if (this.connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.connectionTimeout)));
            }
            catch (Exception exception) {
                this.logger.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private String stringFromResetBits(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < RESET_STATES.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuilder.append(RESET_STATES[i]).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker tracker;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.tracker = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.tracker.recordConnectionUsageMillis(poolEntry.getMillisSinceBorrowed());
        }

        @Override
        public void recordConnectionCreated(long l) {
            this.tracker.recordConnectionCreatedMillis(l);
        }

        @Override
        public void recordBorrowTimeoutStats(long l) {
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l) {
            long l2;
            poolEntry.lastBorrowed = l2 = ClockSource.currentTime();
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l, l2));
        }

        @Override
        public void recordConnectionTimeout() {
            this.tracker.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.tracker.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long connectionCreatedMillis) {
        }

        default public void recordBorrowTimeoutStats(long startTime) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
            }
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long serialVersionUID = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

