/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.pool.ProxyFactory;
import com.zaxxer.hikari.pool.ProxyStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ProxyDatabaseMetaData
implements DatabaseMetaData {
    protected final ProxyConnection connection;
    protected final DatabaseMetaData delegate;

    ProxyDatabaseMetaData(ProxyConnection proxyConnection, DatabaseMetaData databaseMetaData) {
        this.connection = proxyConnection;
        this.delegate = databaseMetaData;
    }

    final SQLException checkException(SQLException sQLException) {
        return this.connection.checkException(sQLException);
    }

    public final String toString() {
        String string = this.delegate.toString();
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " wrapping " + string;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getProcedures(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getProcedureColumns(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) {
        ResultSet resultSet = this.delegate.getTables(string, string2, string3, stringArray);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getSchemas() {
        ResultSet resultSet = this.delegate.getSchemas();
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getCatalogs() {
        ResultSet resultSet = this.delegate.getCatalogs();
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getTableTypes() {
        ResultSet resultSet = this.delegate.getTableTypes();
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getColumns(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getColumnPrivileges(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getTablePrivileges(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) {
        ResultSet resultSet = this.delegate.getBestRowIdentifier(string, string2, string3, n, bl);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getVersionColumns(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getPrimaryKeys(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getImportedKeys(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getExportedKeys(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        ResultSet resultSet = this.delegate.getCrossReference(string, string2, string3, string4, string5, string6);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getTypeInfo() {
        ResultSet resultSet = this.delegate.getTypeInfo();
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        ResultSet resultSet = this.delegate.getIndexInfo(string, string2, string3, bl, bl2);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        ResultSet resultSet = this.delegate.getUDTs(string, string2, string3, nArray);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getSuperTypes(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getSuperTables(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getAttributes(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) {
        ResultSet resultSet = this.delegate.getSchemas(string, string2);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getClientInfoProperties() {
        ResultSet resultSet = this.delegate.getClientInfoProperties();
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) {
        ResultSet resultSet = this.delegate.getFunctions(string, string2, string3);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getFunctionColumns(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) {
        ResultSet resultSet = this.delegate.getPseudoColumns(string, string2, string3, string4);
        Statement statement = resultSet.getStatement();
        if (statement != null) {
            statement = ProxyFactory.getProxyStatement(this.connection, statement);
        }
        return ProxyFactory.getProxyResultSet(this.connection, (ProxyStatement)statement, resultSet);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped DatabaseMetaData is not an instance of " + clazz);
    }
}

