/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.animation.showcase.ItemRewardShowcase;
import cz.larkyy.aquaticcratestesting.animation.showcase.ModelRewardShowcase;
import cz.larkyy.aquaticcratestesting.animation.showcase.RewardShowcase;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.hologram.Hologram;
import cz.larkyy.aquaticcratestesting.hologram.impl.AquaticHologram;
import cz.larkyy.aquaticcratestesting.model.Model;
import cz.larkyy.aquaticcratestesting.utils.IReward;
import cz.larkyy.aquaticcratestesting.utils.RewardUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RewardItem {
    private final Animation animation;
    private BukkitRunnable rumbleRunnable;
    private BukkitRunnable aliveRunnable;
    private BukkitRunnable hologramRunnable;
    private final Vector vector;
    private final boolean gravity;
    private final int rumblingLength;
    private final int rumblingPeriod;
    private final int aliveLength;
    private Hologram hologram;
    private Reward cachedReward;
    private final Vector offset;
    private RewardShowcase rewardShowcase;
    public static final NamespacedKey REWARD_ITEM_KEY = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), "AQUATICCRATES_REWARD_ITEM");
    private final Player p;

    public RewardItem(Player player, Animation animation, int n, int n2, int n3, Vector vector, boolean bl, Vector vector2) {
        this.p = player;
        this.rumblingLength = n;
        this.rumblingPeriod = n2;
        this.aliveLength = n3;
        this.animation = animation;
        this.vector = vector;
        this.gravity = bl;
        this.cachedReward = null;
        this.offset = vector2;
    }

    public void spawn() {
        if (this.rewardShowcase != null) {
            return;
        }
        this.startRumbling();
        this.startAliveCountdown();
        this.startHologramMoving();
    }

    private void spawnHologram(Reward reward) {
        this.despawnHologram();
        this.cachedReward = reward;
        Location location = this.rewardShowcase.getLocation().clone().add(0.0, reward.getHologramYOffset(), 0.0);
        this.hologram = new AquaticHologram(location, reward.getHologram());
        if (this.p == null) {
            this.hologram.spawn(new ArrayList<Player>(Bukkit.getOnlinePlayers()), list -> list.replaceAll(string -> string.replace("%reward-name%", reward.getItem().getItem().getItemMeta().getDisplayName())));
        } else {
            this.hologram.spawn(Arrays.asList(this.p), list -> list.replaceAll(string -> string.replace("%reward-name%", reward.getItem().getItem().getItemMeta().getDisplayName())));
        }
    }

    private void updateHologram(Reward reward) {
        if (this.hologram == null) {
            this.spawnHologram(reward);
            return;
        }
        if (this.cachedReward == reward) {
            return;
        }
        this.cachedReward = reward;
        Location location = this.rewardShowcase.getLocation().clone().add(0.0, reward.getHologramYOffset(), 0.0);
        this.hologram.setLocation(location);
        this.hologram.setLines(reward.getHologram());
        this.hologram.update(list -> list.replaceAll(string -> string.replace("%reward-name%", reward.getItem().getItem().getItemMeta().getDisplayName())));
    }

    private void despawnHologram() {
        if (this.hologram != null) {
            this.hologram.despawn();
            this.hologram = null;
        }
    }

    private void startHologramMoving() {
        this.hologramRunnable = new BukkitRunnable(){

            public void run() {
                RewardItem.this.hologram.move(RewardItem.this.rewardShowcase.getLocation().clone().add(0.0, RewardItem.this.cachedReward.getHologramYOffset(), 0.0));
            }
        };
        this.hologramRunnable.runTaskTimer((Plugin)AquaticCratesTesting.instance(), 0L, 1L);
    }

    private void startRumbling() {
        this.rumbleRunnable = new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= RewardItem.this.rumblingLength) {
                    RewardItem.this.updateItem(RewardItem.this.animation.getReward().get());
                    this.cancel();
                    return;
                }
                List<IReward> list = RewardUtils.getPossibleRewards(RewardItem.this.animation.getPlayer(), RewardItem.this.animation.getAnimationManager().getCrate().getRewards(), RewardItem.this.animation.getAnimationManager().getCrate());
                Reward reward = (Reward)RewardUtils.getRandomReward(list, RewardItem.this.cachedReward);
                RewardItem.this.updateItem(reward);
                this.tick += RewardItem.this.rumblingPeriod;
            }
        };
        this.rumbleRunnable.runTaskTimer((Plugin)AquaticCratesTesting.instance(), 0L, (long)this.rumblingPeriod);
    }

    private void updateItem(Reward reward) {
        if (this.rewardShowcase == null) {
            this.spawnItem(reward);
        }
        Location location = this.rewardShowcase.getLocation().clone();
        Object object = this.rewardShowcase;
        if (object instanceof ItemRewardShowcase) {
            ItemRewardShowcase itemRewardShowcase = (ItemRewardShowcase)object;
            if (reward.getModel() != null) {
                object = PlaceholderAPI.setPlaceholders((Player)this.p, (String)reward.getModel());
                this.rewardShowcase.destroy();
                this.rewardShowcase = null;
                Location location2 = location.clone();
                location2.setYaw(reward.getModelYaw());
                this.rewardShowcase = new ModelRewardShowcase(Model.create((String)object, location2, this.p, this.p));
            } else {
                itemRewardShowcase.getItem().setItemStack(reward.getItem().getItem());
            }
        } else {
            object = this.rewardShowcase;
            if (object instanceof ModelRewardShowcase) {
                ModelRewardShowcase modelRewardShowcase = (ModelRewardShowcase)object;
                this.rewardShowcase.destroy();
                if (reward.getModel() != null) {
                    this.rewardShowcase = null;
                    object = location.getWorld().dropItem(location, reward.getItem().getItem());
                    object.setItemStack(reward.getItem().getItem().clone());
                    object.setPickupDelay(Integer.MAX_VALUE);
                    object.setGravity(this.gravity);
                    PersistentDataContainer persistentDataContainer = object.getPersistentDataContainer();
                    persistentDataContainer.set(REWARD_ITEM_KEY, PersistentDataType.INTEGER, (Object)1);
                    if (this.p != null) {
                        ArrayList<Player> arrayList = new ArrayList<Player>(Bukkit.getOnlinePlayers());
                        arrayList.remove(this.p);
                        AquaticCratesTesting.getNmsHandler().despawnEntity(Arrays.asList(object.getEntityId()), arrayList);
                    }
                    this.rewardShowcase = new ItemRewardShowcase((Item)object);
                } else {
                    object = location.clone();
                    object.setYaw(reward.getModelYaw());
                    String string = PlaceholderAPI.setPlaceholders((Player)this.p, (String)reward.getModel());
                    this.rewardShowcase = new ModelRewardShowcase(Model.create(string, (Location)object, this.p, this.p));
                }
            }
        }
        this.updateHologram(reward);
    }

    private void startAliveCountdown() {
        this.aliveRunnable = new BukkitRunnable(){

            public void run() {
                RewardItem.this.despawn();
            }
        };
        this.aliveRunnable.runTaskLater((Plugin)AquaticCratesTesting.instance(), (long)this.aliveLength);
    }

    private void spawnItem(Reward reward) {
        Location location = this.animation.getModel().getLocation().clone().add(0.0, 1.0, 0.0).add(this.offset);
        if (location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        if (reward.getModel() != null) {
            Location location2 = location.clone();
            location2.setYaw(reward.getModelYaw());
            String string = PlaceholderAPI.setPlaceholders((Player)this.p, (String)reward.getModel());
            this.rewardShowcase = new ModelRewardShowcase(Model.create(string, location2, this.p, this.p));
        } else {
            Item item = location.getWorld().dropItem(location, reward.getItem().getItem());
            item.setItemStack(reward.getItem().getItem().clone());
            item.setPickupDelay(Integer.MAX_VALUE);
            item.setGravity(this.gravity);
            item.setVelocity(this.vector);
            PersistentDataContainer persistentDataContainer = item.getPersistentDataContainer();
            persistentDataContainer.set(REWARD_ITEM_KEY, PersistentDataType.INTEGER, (Object)1);
            if (this.p != null) {
                ArrayList<Player> arrayList = new ArrayList<Player>(Bukkit.getOnlinePlayers());
                arrayList.remove(this.p);
                AquaticCratesTesting.getNmsHandler().despawnEntity(Arrays.asList(item.getEntityId()), arrayList);
            }
            this.rewardShowcase = new ItemRewardShowcase(item);
        }
    }

    public void despawn() {
        if (this.hologramRunnable != null && !this.hologramRunnable.isCancelled()) {
            this.hologramRunnable.cancel();
        }
        if (this.aliveRunnable != null && !this.aliveRunnable.isCancelled()) {
            this.aliveRunnable.cancel();
        }
        if (this.rumbleRunnable != null && !this.rumbleRunnable.isCancelled()) {
            this.rumbleRunnable.cancel();
        }
        this.despawnHologram();
        if (this.rewardShowcase == null) {
            return;
        }
        this.rewardShowcase.destroy();
        this.rewardShowcase = null;
    }
}

