/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation.impl;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.animation.RewardItem;
import cz.larkyy.aquaticcratestesting.animation.task.PreOpenTitle;
import cz.larkyy.aquaticcratestesting.camera.Camera;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.model.Model;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CinematicAnimation
extends Animation {
    private final Model model;
    private final Camera camera;
    private int i;
    private BukkitRunnable runnable;
    private RewardItem rewardItem = null;
    private final ItemStack helmet;

    public CinematicAnimation(AnimationManager animationManager, Player player, AtomicReference<Reward> atomicReference, Consumer<Animation> consumer) {
        super(animationManager, player, atomicReference, consumer);
        this.helmet = player.getInventory().getHelmet();
        this.runnable = new BukkitRunnable(){

            public void run() {
            }
        };
        this.runnable.runTask((Plugin)AquaticCratesTesting.instance());
        if (this.getAnimationManager().getModelLocation() == null || this.getAnimationManager().getCameraLocation() == null) {
            this.model = null;
            this.camera = null;
            this.reroll();
        } else {
            this.model = this.spawnModel();
            this.camera = this.spawnCamera();
            this.begin();
        }
    }

    @Override
    public void begin() {
        this.getPlayer().getPersistentDataContainer().set(KEY, PersistentDataType.INTEGER, (Object)1);
        PreOpenTitle preOpenTitle = this.getAnimationManager().getPreOpenTitle();
        if (preOpenTitle != null) {
            preOpenTitle.show(this.getPlayer());
        }
        new BukkitRunnable(){

            public void run() {
                CinematicAnimation.this.getPlayer().setInvisible(true);
                CinematicAnimation.this.camera.attachPlayer(() -> {
                    CinematicAnimation.this.model.show(CinematicAnimation.this.getPlayer());
                    CinematicAnimation.this.start();
                });
            }
        }.runTaskLater((Plugin)AquaticCratesTesting.instance(), (long)this.getAnimationManager().getStartDelay());
    }

    @Override
    public void start() {
        String string;
        this.setStarted(true);
        if (this.getAnimationManager().setPumpkinHelmet()) {
            this.getPlayer().getInventory().setHelmet(new ItemStack(Material.CARVED_PUMPKIN));
        }
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        if (this.camera != null) {
            this.camera.teleport(this.getAnimationManager().getCameraLocation().clone().add(0.0, 1.8, 0.0));
        }
        if (this.getAnimationManager().getModelLocation() == null || this.getAnimationManager().getCameraLocation() == null) {
            this.reroll();
            return;
        }
        this.getAnimationManager().showTitle(this.getAnimationManager().getOpeningTitle(), this.getPlayer());
        if (this.getReward().get() == null) {
            string = "open";
        } else {
            string = this.getReward().get().getModelAnimation();
            if (string == null) {
                string = "open";
            }
        }
        this.model.playAnimation(string);
        this.i = 0;
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.runnable = new BukkitRunnable(){

            public void run() {
                CinematicAnimation.this.getAnimationManager().playTask(CinematicAnimation.this.i, CinematicAnimation.this);
                if (CinematicAnimation.this.getAnimationManager().shouldStopAnimation(CinematicAnimation.this.i)) {
                    CinematicAnimation.this.reroll();
                }
                ++CinematicAnimation.this.i;
            }
        };
        this.runnable.runTaskTimer((Plugin)AquaticCratesTesting.instance(), 0L, 1L);
    }

    @Override
    public void reroll() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
            this.runnable = null;
        } else if (this.runnable == null) {
            return;
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        super.reroll();
    }

    @Override
    public void end() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
            this.runnable = null;
        }
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        if (this.model != null) {
            this.model.hide(this.getPlayer());
            this.model.remove();
        }
        if (this.camera != null) {
            this.camera.despawn();
        }
        if (this.getAnimationManager().setPumpkinHelmet()) {
            this.getPlayer().getInventory().setHelmet(this.helmet);
        }
        this.getPlayer().setInvisible(false);
        this.getPlayer().getPersistentDataContainer().remove(KEY);
    }

    @Override
    public void spawnReward(int n, int n2, int n3, Vector vector, boolean bl, Vector vector2) {
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
        }
        this.rewardItem = new RewardItem(this.getPlayer(), this, n, n2, n3, vector, bl, vector2);
        this.rewardItem.spawn();
    }

    private Model spawnModel() {
        String string = this.getAnimationManager().getCrate().getModel();
        return Model.create(string, this.getAnimationManager().getModelLocation(), this.getPlayer(), this.getPlayer());
    }

    private Camera spawnCamera() {
        return new Camera(this.getAnimationManager().getCameraLocation(), this.getPlayer());
    }

    public void moveCamera(Vector vector, int n, float f, float f2) {
        this.camera.setMovement(vector, n, f, f2);
    }

    public void teleportCamera(Vector vector, float f, float f2) {
        Location location = this.camera.location().clone().add(vector);
        location.setYaw(f);
        location.setPitch(f2);
        this.camera.teleport(location);
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

