/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.api.events.CratePlaceEvent;
import cz.larkyy.aquaticcratestesting.api.events.MultiCratePlaceEvent;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.config.CrateConfig;
import cz.larkyy.aquaticcratestesting.config.MultiCrateConfig;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.CrateBase;
import cz.larkyy.aquaticcratestesting.crate.MultiCrate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.PlacedMultiCrate;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CrateHandler {
    private final Map<String, Crate> crates = new HashMap<String, Crate>();
    private final Map<Location, PlacedCrate> locations = new HashMap<Location, PlacedCrate>();
    private final Map<String, MultiCrate> multiCrates = new HashMap<String, MultiCrate>();
    private final Map<Location, PlacedMultiCrate> multiLocations = new HashMap<Location, PlacedMultiCrate>();
    private static final Config crateData = new Config((JavaPlugin)AquaticCratesTesting.instance(), "locations.yml");

    public void removePlacedCrate(Location location) {
        PlacedCrate placedCrate = this.locations.remove(location);
        if (placedCrate == null) {
            return;
        }
        for (Location location2 : placedCrate.getHitboxLocations()) {
            this.locations.remove(location2);
        }
        placedCrate.destroy();
        this.saveCrates();
    }

    public void removePlacedMultiCrate(Location location) {
        PlacedMultiCrate placedMultiCrate = this.multiLocations.remove(location);
        if (placedMultiCrate == null) {
            return;
        }
        placedMultiCrate.destroy();
        this.saveCrates();
    }

    public Crate getCrate(String string) {
        return this.crates.get(string);
    }

    public MultiCrate getMultiCrate(String string) {
        return this.multiCrates.get(string);
    }

    public PlacedCrate spawnCrate(Location location, Crate crate) {
        PlacedCrate placedCrate = new PlacedCrate(crate, location);
        CratePlaceEvent cratePlaceEvent = new CratePlaceEvent(placedCrate);
        Bukkit.getServer().getPluginManager().callEvent((Event)cratePlaceEvent);
        Location location2 = location.clone().getBlock().getLocation();
        location2.setYaw(0.0f);
        for (Location location3 : placedCrate.getHitboxLocations()) {
            location3.getBlock().setType(cratePlaceEvent.getBlockMaterial());
            this.locations.put(location3, placedCrate);
        }
        return placedCrate;
    }

    public PlacedMultiCrate spawnMultiCrate(Location location, MultiCrate multiCrate) {
        PlacedMultiCrate placedMultiCrate = new PlacedMultiCrate(multiCrate, location);
        MultiCratePlaceEvent multiCratePlaceEvent = new MultiCratePlaceEvent(placedMultiCrate);
        Bukkit.getServer().getPluginManager().callEvent((Event)multiCratePlaceEvent);
        Location location2 = location.clone().getBlock().getLocation();
        location2.getBlock().setType(multiCratePlaceEvent.getBlockMaterial());
        location2.setYaw(0.0f);
        this.multiLocations.put(location2, placedMultiCrate);
        return placedMultiCrate;
    }

    public PlacedCrate getPlacedCrate(Location location) {
        return this.locations.get(location);
    }

    public PlacedMultiCrate getPlacedMultiCrate(Location location) {
        return this.multiLocations.get(location);
    }

    public void load() {
        this.loadCrates();
    }

    private void loadCrates() {
        float f;
        double d;
        double d2;
        double d3;
        CrateBase crateBase;
        crateData.load();
        File file = new File(AquaticCratesTesting.instance().getDataFolder(), "crates/");
        file.mkdirs();
        for (File object2 : file.listFiles()) {
            crateBase = new CrateConfig((JavaPlugin)AquaticCratesTesting.instance(), object2).loadCrate();
            if (crateBase == null) continue;
            this.crates.put(crateBase.getIdentifier(), (Crate)crateBase);
        }
        file = new File(AquaticCratesTesting.instance().getDataFolder(), "multicrates/");
        file.mkdirs();
        for (File file2 : file.listFiles()) {
            crateBase = new MultiCrateConfig((JavaPlugin)AquaticCratesTesting.instance(), file2).loadCrate();
            if (crateBase == null) continue;
            this.multiCrates.put(crateBase.getIdentifier(), (MultiCrate)crateBase);
        }
        if (crateData.getConfiguration().contains("crates")) {
            for (String string : crateData.getConfiguration().getStringList("crates")) {
                String[] stringArray = string.split("\\|");
                Crate crate = Crate.get(stringArray[0]);
                if (crate == null || (crateBase = Bukkit.getWorld((String)stringArray[1])) == null) continue;
                d3 = Double.parseDouble(stringArray[2]);
                d2 = Double.parseDouble(stringArray[3]);
                d = Double.parseDouble(stringArray[4]);
                f = Float.parseFloat(stringArray[5]);
                this.spawnCrate(new Location((World)crateBase, d3, d2, d, f, 0.0f), crate);
            }
        }
        if (crateData.getConfiguration().contains("multi-crates")) {
            for (String string : crateData.getConfiguration().getStringList("multi-crates")) {
                String[] stringArray = string.split("\\|");
                MultiCrate multiCrate = this.getMultiCrate(stringArray[0]);
                if (multiCrate == null || (crateBase = Bukkit.getWorld((String)stringArray[1])) == null) continue;
                d3 = Double.parseDouble(stringArray[2]);
                d2 = Double.parseDouble(stringArray[3]);
                d = Double.parseDouble(stringArray[4]);
                f = Float.parseFloat(stringArray[5]);
                this.spawnMultiCrate(new Location((World)crateBase, d3, d2, d, f, 0.0f), multiCrate);
            }
        }
    }

    public void unloadCrates() {
        for (PlacedCrate object : this.locations.values()) {
            object.destroy();
        }
        for (PlacedMultiCrate placedMultiCrate : this.multiLocations.values()) {
            placedMultiCrate.destroy();
        }
    }

    public void saveCrates() {
        new BukkitRunnable(){

            public void run() {
                Location location;
                Object object;
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (Map.Entry<Location, PlacedCrate> entry : CrateHandler.this.locations.entrySet()) {
                    object = entry.getValue();
                    location = ((PlacedCrate)object).getLocation();
                    arrayList.add((CallSite)((Object)(((PlacedCrate)object).getCrate().getIdentifier() + "|" + location.getWorld().getName() + "|" + location.getX() + "|" + location.getY() + "|" + location.getZ() + "|" + location.getYaw())));
                }
                crateData.getConfiguration().set("crates", arrayList);
                arrayList = new ArrayList();
                for (Map.Entry<Location, Object> entry : CrateHandler.this.multiLocations.entrySet()) {
                    object = (PlacedMultiCrate)entry.getValue();
                    location = ((PlacedMultiCrate)object).getLocation();
                    arrayList.add((CallSite)((Object)(((PlacedMultiCrate)object).getMultiCrate().getIdentifier() + "|" + location.getWorld().getName() + "|" + location.getX() + "|" + location.getY() + "|" + location.getZ() + "|" + location.getYaw())));
                }
                crateData.getConfiguration().set("multi-crates", arrayList);
                crateData.save();
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    public boolean isInAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().isInAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public boolean skipAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().skipAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public boolean forceSkipAnimation(Player player) {
        for (Crate crate : this.crates.values()) {
            if (!crate.getAnimationManager().get().forceSkipAnimation(player)) continue;
            return true;
        }
        return false;
    }

    public Map<Location, PlacedCrate> getLocations() {
        return this.locations;
    }

    public Map<String, Crate> getCrates() {
        return this.crates;
    }

    public Map<Location, PlacedMultiCrate> getMultiLocations() {
        return this.multiLocations;
    }

    public Map<String, MultiCrate> getMultiCrates() {
        return this.multiCrates;
    }
}

