/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.crate.CrateBase;
import cz.larkyy.aquaticcratestesting.crate.PlacedMultiCrate;
import cz.larkyy.aquaticcratestesting.crate.inventories.MultiPreviewGUI;
import cz.larkyy.aquaticcratestesting.crate.model.ModelSettings;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MultiCrate
extends CrateBase {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)AquaticCratesTesting.instance(), "MultiCrateIdentifier");
    private final List<String> crates;
    private final AtomicReference<MultiPreviewGUI> previewGUI;

    public MultiCrate(String string, String string2, ModelSettings modelSettings, List<String> list, double d, List<String> list2, AtomicReference<MultiPreviewGUI> atomicReference, int n, int n2) {
        super(string, string2, modelSettings, list, d, n, n2);
        this.crates = list2;
        this.previewGUI = atomicReference;
    }

    public List<String> getCrates() {
        return this.crates;
    }

    public void openPreview(Player player, PlacedMultiCrate placedMultiCrate) {
        if (AquaticCratesTesting.getCrateHandler().isInAnimation(player)) {
            return;
        }
        MultiPreviewGUI multiPreviewGUI = this.previewGUI.get();
        if (multiPreviewGUI == null) {
            return;
        }
        multiPreviewGUI.open(player, placedMultiCrate);
    }

    public void giveCrate(Player player) {
        ItemStack itemStack = new ItemStack(Material.CHEST);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName("\u00a7fCrate: " + this.getIdentifier());
        itemMeta.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)this.getIdentifier());
        itemStack.setItemMeta(itemMeta);
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public static MultiCrate get(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        String string = (String)itemMeta.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        return MultiCrate.get(string);
    }

    public static MultiCrate get(String string) {
        return AquaticCratesTesting.getCrateHandler().getMultiCrate(string);
    }
}

