/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.MultiCrate;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.model.ModelAnimationHandler;
import cz.larkyy.aquaticcratestesting.hologram.Hologram;
import cz.larkyy.aquaticcratestesting.hologram.impl.AquaticHologram;
import cz.larkyy.aquaticcratestesting.model.Model;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PlacedMultiCrate {
    private final MultiCrate multiCrate;
    private final Location location;
    private final Map<String, PlacedCrate> placedCrates;
    private final Model model;
    private final Hologram hologram;
    private final ModelAnimationHandler modelAnimationHandler;

    public PlacedMultiCrate(MultiCrate multiCrate, Location location) {
        this.location = location;
        this.multiCrate = multiCrate;
        this.hologram = new AquaticHologram(location.clone().add(0.0, multiCrate.getHologramYOffset(), 0.0), multiCrate.getHologram());
        this.hologram.spawn(new ArrayList<Player>(Bukkit.getOnlinePlayers()), list -> {});
        this.model = Model.create(multiCrate.getModel(), location, null, null);
        this.placedCrates = this.createPlacedCrates();
        this.modelAnimationHandler = new ModelAnimationHandler(this.model, multiCrate);
    }

    private Map<String, PlacedCrate> createPlacedCrates() {
        HashMap<String, PlacedCrate> hashMap = new HashMap<String, PlacedCrate>();
        for (String string : this.multiCrate.getCrates()) {
            Crate crate = Crate.get(string);
            if (crate == null) continue;
            hashMap.put(string, new PlacedCrate(crate, this.location, this.model, this.hologram));
        }
        return hashMap;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public MultiCrate getMultiCrate() {
        return this.multiCrate;
    }

    public Map<String, PlacedCrate> getPlacedCrates() {
        return this.placedCrates;
    }

    public Location getLocation() {
        return this.location;
    }

    public Model getModel() {
        return this.model;
    }

    public void destroy() {
        this.modelAnimationHandler.setCancelled(true);
        this.model.remove();
        this.location.getBlock().setType(Material.AIR);
        this.hologram.despawn();
    }

    public void open(CratePlayer cratePlayer, String string, boolean bl) {
        PlacedCrate placedCrate = this.placedCrates.get(string);
        if (placedCrate == null) {
            return;
        }
        placedCrate.getCrate().open(cratePlayer, placedCrate, bl);
    }
}

