/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.dabatase.drivers;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.dabatase.drivers.Driver;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MySQLDriver
implements Driver {
    private HikariConfig config;
    private HikariDataSource dataSource;
    private String keysTableName;

    @Override
    public void setup() {
        this.keysTableName = String.format("%saquaticcrates_keys", this.getCfg().getString("prefix"));
        this.config = new HikariConfig();
        Object object = this.getCfg().getString("ip");
        Object object2 = this.getCfg().getString("port");
        String string = this.getCfg().getString("name");
        String string2 = this.getCfg().getString("user");
        String string3 = this.getCfg().getString("password");
        this.config.setJdbcUrl(String.format("jdbc:mysql://%s:%s/%s", object, object2, string));
        this.config.setMaximumPoolSize(10);
        this.config.setPoolName("AquaticCrates DB pool");
        this.config.setUsername(string2);
        this.config.setPassword(string3);
        this.dataSource = new HikariDataSource(this.config);
        object = this.getConnection();
        try {
            object2 = object.createStatement();
            try {
                object2.execute("CREATE TABLE IF NOT EXISTS " + this.keysTableName + " (\n    id int NOT NULL AUTO_INCREMENT,\n    UniqueID NVARCHAR(64) NOT NULL,\n    Identifier NVARCHAR(64) NOT NULL,\n    Amount INT NOT NULL,\n    PRIMARY KEY (id)\n);");
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
    }

    private Connection getConnection() {
        return this.dataSource.getConnection();
    }

    @Override
    public void loadPlayer(final Player player, final Consumer<ResultSet> consumer) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLDriver.this.getConnection();){
                    try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT Identifier, Amount\nFROM " + MySQLDriver.this.keysTableName + "\nWHERE UniqueID = ?;");){
                        preparedStatement.setString(1, player.getUniqueId().toString());
                        consumer.accept(preparedStatement.executeQuery());
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void loadPlayers(final Consumer<ResultSet> consumer) {
        new BukkitRunnable(){

            public void run() {
                try (Connection connection = MySQLDriver.this.getConnection();){
                    try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT UniqueID, Identifier, Amount\nFROM " + MySQLDriver.this.keysTableName + ";");){
                        consumer.accept(preparedStatement.executeQuery());
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void savePlayer(final CratePlayer cratePlayer, boolean bl) {
        final Player player = cratePlayer.getPlayer();
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try (Connection connection = MySQLDriver.this.getConnection();){
                    for (Map.Entry<String, Integer> entry : cratePlayer.getVirtualKeys().entrySet()) {
                        String string = entry.getKey();
                        Integer n = entry.getValue();
                        try {
                            PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM " + MySQLDriver.this.keysTableName + " WHERE UniqueID = ? AND Identifier = ?");
                            try {
                                PreparedStatement preparedStatement2;
                                preparedStatement.setString(1, player.getUniqueId().toString());
                                preparedStatement.setString(2, string);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                if (resultSet.next()) {
                                    preparedStatement2 = connection.prepareStatement("UPDATE " + MySQLDriver.this.keysTableName + " SET Amount = ? WHERE UniqueID = ? AND Identifier = ?");
                                    try {
                                        preparedStatement2.setInt(1, n);
                                        preparedStatement2.setString(2, player.getUniqueId().toString());
                                        preparedStatement2.setString(3, string);
                                        preparedStatement2.execute();
                                        continue;
                                    }
                                    finally {
                                        if (preparedStatement2 != null) {
                                            preparedStatement2.close();
                                        }
                                        continue;
                                    }
                                }
                                preparedStatement2 = connection.prepareStatement("REPLACE INTO " + MySQLDriver.this.keysTableName + " (UniqueID, Identifier, Amount) VALUES (?, ?, ?);");
                                try {
                                    preparedStatement2.setString(1, player.getUniqueId().toString());
                                    preparedStatement2.setString(2, string);
                                    preparedStatement2.setInt(3, n);
                                    preparedStatement2.execute();
                                }
                                finally {
                                    if (preparedStatement2 == null) continue;
                                    preparedStatement2.close();
                                }
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new RuntimeException(sQLException);
                            return;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        };
        if (bl) {
            bukkitRunnable.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
        } else {
            bukkitRunnable.run();
        }
    }

    @Override
    public void savePlayers(final boolean bl) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    CratePlayer cratePlayer = CratePlayer.get(player);
                    MySQLDriver.this.savePlayer(cratePlayer, bl);
                }
            }
        };
        if (bl) {
            bukkitRunnable.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
        } else {
            bukkitRunnable.run();
        }
    }

    private FileConfiguration getCfg() {
        return AquaticCratesTesting.getDatabaseManager().getCfg();
    }
}

