/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.dabatase.drivers;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.dabatase.drivers.Driver;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SQLiteDriver
implements Driver {
    private final File databaseFile = new File(AquaticCratesTesting.instance().getDataFolder(), "database.db");
    private Connection activeConnection;

    @Override
    public void setup() {
        Class.forName("org.sqlite.JDBC");
        AquaticCratesTesting.instance().getDataFolder().mkdirs();
        this.databaseFile.createNewFile();
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE IF NOT EXISTS aquaticcrates_keys (\n    id integer primary key,\n    UniqueID NVARCHAR(64) NOT NULL,\n    Identifier NVARCHAR(64) NOT NULL,\n    Amount INT NOT NULL\n);");
        statement.close();
    }

    @Override
    public void loadPlayer(final Player player, final Consumer<ResultSet> consumer) {
        new BukkitRunnable(){

            public void run() {
                Connection connection = SQLiteDriver.this.getConnection();
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT Identifier, Amount\nFROM aquaticcrates_keys\nWHERE UniqueID = ?;");){
                    preparedStatement.setString(1, player.getUniqueId().toString());
                    consumer.accept(preparedStatement.executeQuery());
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void loadPlayers(final Consumer<ResultSet> consumer) {
        new BukkitRunnable(){

            public void run() {
                Connection connection = SQLiteDriver.this.getConnection();
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT UniqueID, Identifier, Amount\nFROM aquaticcrates_keys;");){
                    consumer.accept(preparedStatement.executeQuery());
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void savePlayer(final CratePlayer cratePlayer, boolean bl) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                try (Connection connection = SQLiteDriver.this.getConnection();){
                    cratePlayer.getVirtualKeys().forEach((string, n) -> {
                        block21: {
                            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM aquaticcrates_keys WHERE UniqueID = ? AND Identifier = ?");){
                                preparedStatement.setString(1, cratePlayer.getPlayer().getUniqueId().toString());
                                preparedStatement.setString(2, (String)string);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                if (resultSet.next()) {
                                    try (PreparedStatement preparedStatement2 = connection.prepareStatement("UPDATE aquaticcrates_keys SET Amount = ? WHERE UniqueID = ? AND Identifier = ?");){
                                        preparedStatement2.setInt(1, (int)n);
                                        preparedStatement2.setString(2, cratePlayer.getPlayer().getUniqueId().toString());
                                        preparedStatement2.setString(3, (String)string);
                                        preparedStatement2.execute();
                                        break block21;
                                    }
                                }
                                try (PreparedStatement preparedStatement3 = connection.prepareStatement("INSERT OR REPLACE INTO aquaticcrates_keys (UniqueID, Identifier, Amount) VALUES (?, ?, ?);");){
                                    preparedStatement3.setString(1, cratePlayer.getPlayer().getUniqueId().toString());
                                    preparedStatement3.setString(2, (String)string);
                                    preparedStatement3.setInt(3, (int)n);
                                    preparedStatement3.execute();
                                }
                            }
                            catch (SQLException sQLException) {
                                throw new RuntimeException(sQLException);
                            }
                        }
                    });
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        };
        if (bl) {
            bukkitRunnable.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
        } else {
            bukkitRunnable.run();
        }
    }

    @Override
    public void savePlayers(boolean bl) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try (Connection connection = SQLiteDriver.this.getConnection();){
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        CratePlayer cratePlayer = CratePlayer.get(player);
                        for (Map.Entry<String, Integer> entry : cratePlayer.getVirtualKeys().entrySet()) {
                            String string = entry.getKey();
                            Integer n = entry.getValue();
                            try {
                                PreparedStatement preparedStatement = connection.prepareStatement("SELECT id FROM aquaticcrates_keys WHERE UniqueID = ? AND Identifier = ?");
                                try {
                                    PreparedStatement preparedStatement2;
                                    preparedStatement.setString(1, player.getPlayer().getUniqueId().toString());
                                    preparedStatement.setString(2, string);
                                    ResultSet resultSet = preparedStatement.executeQuery();
                                    if (resultSet.next()) {
                                        preparedStatement2 = connection.prepareStatement("UPDATE aquaticcrates_keys SET Amount = ? WHERE UniqueID = ? AND Identifier = ?");
                                        try {
                                            preparedStatement2.setInt(1, n);
                                            preparedStatement2.setString(2, player.getPlayer().getUniqueId().toString());
                                            preparedStatement2.setString(3, string);
                                            preparedStatement2.execute();
                                            continue;
                                        }
                                        finally {
                                            if (preparedStatement2 != null) {
                                                preparedStatement2.close();
                                            }
                                            continue;
                                        }
                                    }
                                    preparedStatement2 = connection.prepareStatement("INSERT OR REPLACE INTO aquaticcrates_keys (UniqueID, Identifier, Amount) VALUES (?, ?, ?);");
                                    try {
                                        preparedStatement2.setString(1, player.getPlayer().getUniqueId().toString());
                                        preparedStatement2.setString(2, string);
                                        preparedStatement2.setInt(3, n);
                                        preparedStatement2.execute();
                                    }
                                    finally {
                                        if (preparedStatement2 == null) continue;
                                        preparedStatement2.close();
                                    }
                                }
                                finally {
                                    if (preparedStatement == null) continue;
                                    preparedStatement.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                throw new RuntimeException(sQLException);
                            }
                        }
                        continue;
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        };
        if (bl) {
            bukkitRunnable.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
        } else {
            bukkitRunnable.run();
        }
    }

    private Connection getConnection() {
        try {
            if (this.activeConnection != null && !this.activeConnection.isClosed()) {
                return this.activeConnection;
            }
            Class.forName("org.sqlite.SQLiteDataSource");
            this.activeConnection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getPath());
        }
        catch (ClassNotFoundException | SQLException exception) {
            throw new RuntimeException(exception);
        }
        return this.activeConnection;
    }
}

